
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np
from scipy.stats import gaussian_kde
##################### yield ##############################################################
#Defect density: D
D_5nm=np.array([0.1136,0.1111,0.1086,0.1061,0.1036,0.101525,0.09945,0.097375,0.0953,0.094425,0.09355,0.092675,0.0918,0.090225,0.08865,0.087075,0.0855,0.0849875,0.084475,0.0839625,0.08345
])


D_7nm=np.array([0.1384,0.134575,0.13075,0.126925,0.1231,0.12015,0.1172,0.11425,0.1113,0.10885,0.1064,0.10395,0.1015,0.101325,0.10115,0.100975,0.1008,0.10083,0.10086,0.10089,0.10092
])


D_10nm=np.array([0.1551,0.145175,0.13525,0.125325,0.1154,0.11089,0.10638,0.10187,0.09736,0.0971875,0.097015,0.0968425,0.09667,0.095975,0.09528,0.094585,0.09389,0.094585,0.09528,0.095975,0.09667
])


D_16nm=np.array([0.2052,0.19262,0.18005,0.167475,0.1549,0.14677,0.13864,0.13051,0.12238,0.117885,0.11339,0.108895,0.1044,0.101925,0.09945,0.096975,0.0945,0.092825,0.09115,0.089475,0.0878,0.084525,0.08125,0.077975,0.0747,0.07465,0.0746,0.07455,0.0745,0.073225,0.07195,0.070675,0.0694
])

##Yield=e^-(DA), A is diesize
A = 1 

Y_5nm = np.e **-(D_5nm*A)
Y_7nm = np.e **-(D_7nm*A)
Y_10nm = np.e **-(D_10nm*A)
Y_16nm = np.e **-(D_16nm*A)


##  V100-12nm-8.15cm2,   H100-4nm-8.14cm2
Y_V100 = np.e **-(D_10nm*8.15)
Y_H100 = np.e **-(D_5nm*8.14)

#plot

plt.figure(figsize=(10, 6), dpi=500)

sns.histplot(D_5nm, kde=True, color='r', stat='density', alpha=0.2,edgecolor=None,label='5nm')
sns.histplot(D_7nm, kde=True,color='g', stat='density', alpha=0.2,edgecolor=None,label='7nm')
sns.histplot(D_10nm,kde=True, color='b', stat='density', alpha=0.2,edgecolor=None,label='10nm')
sns.histplot(D_16nm, kde=True,color='black', stat='density', alpha=0.2,edgecolor=None,label='16nm')



plt.xlabel('Defect Density', fontsize=30)
plt.ylabel('Probability density', fontsize=30)


plt.legend(fontsize=25)

plt.xticks(fontsize=25)
plt.yticks(fontsize=25)


plt.tight_layout()
plt.savefig('y.pdf',dpi=500)