#!/bin/bash
set -e  
set -o pipefail

# --- Conda init ---
if ! command -v conda &> /dev/null; then
    echo "❌ Conda unavailable. Please install Conda first."
    exit 1
fi

source "$(conda info --base)/etc/profile.d/conda.sh"

ENV_NAME="llava-uhd-v3"
PYTHON_VERSION="3.10"

if conda env list | grep -qE "^$ENV_NAME\s"; then
    echo "✅ Conda  '$ENV_NAME' exists. "
else
    echo "🚀 Creating Conda '$ENV_NAME' (Python $PYTHON_VERSION)..."
    conda create -y -n "$ENV_NAME" python="$PYTHON_VERSION" -c defaults -c conda-forge
    echo "✅ Created Conda environment '$ENV_NAME'."
fi

echo "📦 pip install ..."
conda run -n "$ENV_NAME" pip install -q --upgrade pip
conda run -n "$ENV_NAME" pip install -q imgaug openpyxl
conda run -n "$ENV_NAME" pip install -q torch==2.1.2 torchvision==0.16.2 numpy==1.24
conda run -n "$ENV_NAME" pip install -q -e ".[train]"
conda run -n "$ENV_NAME" pip install -q -e .
conda run -n "$ENV_NAME" pip install -q ./flash_attn-2.7.0.post1+cu12torch2.1cxx11abiFALSE-cp310-cp310-linux_x86_64.whl
conda run -n "$ENV_NAME" wandb offline

conda activate $ENV_NAME
echo "🎉 '$ENV_NAME' install successfully!"
