#!/bin/bash

mkdir -p ~/miniconda3
wget https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-x86_64.sh -O ~/miniconda3/miniconda.sh
bash ~/miniconda3/miniconda.sh -b -u -p ~/miniconda3
rm ~/miniconda3/miniconda.sh
~/miniconda3/bin/conda init bash
source ~/miniconda3/bin/activate
conda create -n hydragen -y python=3.11.5
conda activate hydragen
conda install -y pytorch==2.1.2 torchvision==0.16.2 torchaudio==2.1.2 pytorch-cuda=12.1 -c pytorch -c nvidia
conda install -y nvidia/label/cuda-12.1.0::cuda
cd /expdata/hydragen
pip install packaging==24.0 ninja==1.11.1.1 datasets torchmetrics evaluate
pip install -e .
python3 -c "from huggingface_hub.hf_api import HfFolder; HfFolder.save_token('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')"
torchrun --standalone --nproc_per_node=1 scripts/drop_hay_needles.py --pretrained-name meta-llama/Meta-Llama-3-8B  --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.drop.hay
torchrun --standalone --nproc_per_node=1 scripts/quac_hay_needles.py --pretrained-name meta-llama/Meta-Llama-3-8B  --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.quac.hay
torchrun --standalone --nproc_per_node=1 scripts/squad_hay_needles.py --pretrained-name meta-llama/Meta-Llama-3-8B  --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.squad.hay
