#!/bin/bash

pip install GPUtil huggingface-hub==0.23.2 tokenizers==0.20.0 accelerate==0.26.0 typer==0.9.0 datasets==3.0.0 evaluate ortools==9.9.3963 binpacking wikipedia
python3 -c "from huggingface_hub.hf_api import HfFolder; HfFolder.save_token('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')"
cd /expdata/nlpwork-parallel-prompting/our-transformer-4.46.1/src
torchrun --standalone --nproc_per_node=1 squad_onedocshot_our_sdpa_neddles.py --pretrained-name meta-llama/Meta-Llama-3-8B --save-dir /result/our_needles --save-name=hydragen --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.maxdoc.squad.our
torchrun --standalone --nproc_per_node=1 quac_onedocshot_our_sdpa_neddles.py --pretrained-name meta-llama/Meta-Llama-3-8B --save-dir /result/our_needles --save-name=hydragen --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.maxdoc.quac.our
torchrun --standalone --nproc_per_node=1 drop_onedocshot_our_sdpa_neddles.py --pretrained-name meta-llama/Meta-Llama-3-8B --save-dir /result/our_needles --save-name=hydragen --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.maxdoc.drop.our
cd /expdata/nlpwork-parallel-prompting/baseline/transformers-4.46.1/src/
torchrun --standalone --nproc_per_node=1 squad_onedocshot_baseline_needles.py --pretrained-name meta-llama/Meta-Llama-3-8B --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.maxdoc.squad.base
torchrun --standalone --nproc_per_node=1 squad_onedocshot_batch_baseline_needles.py --pretrained-name meta-llama/Meta-Llama-3-8B --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.maxdoc.squad.batch
torchrun --standalone --nproc_per_node=1 quac_onedocshot_baseline_needles.py --pretrained-name meta-llama/Meta-Llama-3-8B --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.maxdoc.quac.base
torchrun --standalone --nproc_per_node=1 quac_onedocshot_batch_baseline_needles.py --pretrained-name meta-llama/Meta-Llama-3-8B --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.maxdoc.quac.batch
torchrun --standalone --nproc_per_node=1 drop_onedocshot_baseline_needles.py --pretrained-name meta-llama/Meta-Llama-3-8B --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.maxdoc.drop.base
torchrun --standalone --nproc_per_node=1 drop_onedocshot_batch_baseline_needles.py --pretrained-name meta-llama/Meta-Llama-3-8B --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 500 --base-q-length 32 --num-timing-iters 10 --num-warmup-iters 2 > test.llama3.maxdoc.drop.batch
