#!/bin/bash

mkdir -p ~/miniconda3  &&
wget https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-x86_64.sh -O ~/miniconda3/miniconda.sh  &&
bash ~/miniconda3/miniconda.sh -b -u -p ~/miniconda3  &&
rm ~/miniconda3/miniconda.sh  &&
~/miniconda3/bin/conda init bash  &&
source ~/miniconda3/bin/activate  &&
conda create -n hydragen -y python=3.11.5  &&
conda activate hydragen  &&
conda install -y pytorch==2.1.2 torchvision==0.16.2 torchaudio==2.1.2 pytorch-cuda=12.1 -c pytorch -c nvidia  &&
conda install -y nvidia/label/cuda-12.1.0::cuda  &&
pip install packaging==24.0 ninja==1.11.1.1  ortools==9.9.3963 binpacking==1.5.2 datasets torchmetrics evaluate &&
cd /expdata/hydragen  && pip install -e . &&
cd /expdata/hydragen/scripts &&  torchrun --standalone --nproc_per_node=1 base_needles.py --pretrained-name codellama/CodeLlama-7b-Instruct-hf --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 10 --base-q-length 12  --num-timing-iters 3 --num-warmup-iters 1 > base10.log &&torchrun --standalone --nproc_per_node=1 hay_needles_multi.py --pretrained-name codellama/CodeLlama-7b-Instruct-hf --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 10 --base-q-length 12  --num-timing-iters 3 --num-warmup-iters 1 > haymul10.log &&  torchrun --standalone --nproc_per_node=1 base_needles.py --pretrained-name codellama/CodeLlama-7b-Instruct-hf --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 100 --base-q-length 12  --num-timing-iters 3 --num-warmup-iters 1 > base100.log &&torchrun --standalone --nproc_per_node=1 hay_needles_multi.py --pretrained-name codellama/CodeLlama-7b-Instruct-hf --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 100 --base-q-length 12  --num-timing-iters 3 --num-warmup-iters 1 > haymul100.log&&  torchrun --standalone --nproc_per_node=1 base_needles.py --pretrained-name codellama/CodeLlama-7b-Instruct-hf --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 1000 --base-q-length 12  --num-timing-iters 3 --num-warmup-iters 1 > base1000.log &&torchrun --standalone --nproc_per_node=1 hay_needles_multi.py --pretrained-name codellama/CodeLlama-7b-Instruct-hf --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 1000 --base-q-length 12  --num-timing-iters 3 --num-warmup-iters 1 > haymul1000.log &&cd /expdata/nlpwork-parallel-prompting/our-transformer-4.37.2/ && pip install -e . && cd /expdata/hydragen/scripts &&torchrun --standalone --nproc_per_node=1 our_sdpa_needles_test.py --pretrained-name codellama/CodeLlama-7b-Instruct-hf --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 10 --base-q-length 12  --num-timing-iters 3 --num-warmup-iters 1 > our10.log&&torchrun --standalone --nproc_per_node=1 our_sdpa_needles_test.py --pretrained-name codellama/CodeLlama-7b-Instruct-hf --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 100 --base-q-length 12  --num-timing-iters 3 --num-warmup-iters 1 > our100.log&&torchrun --standalone --nproc_per_node=1 our_sdpa_needles_test.py --pretrained-name codellama/CodeLlama-7b-Instruct-hf --save-dir /result/our_needles --save-name=hydragen  --base-prompt-length 1000 --base-q-length 12  --num-timing-iters 3 --num-warmup-iters 1 > our1000.log
