# PARTNR
This repository contains the code to generate the PARTNR dataset and run the baselines described in the paper. We detail below the instructions to run the different components.


## Dataset Generation
To run the dataset generation process. First, generate instructions and object initializations:

```
python -m dataset_generation.benchmark_generation.end2end_pipeline
```
Then, generate evaluation functions:
```
python -m dataset_generation.benchmark_generation.generate_evaluations
```

## Baselines
Below we provide the commands to run the different baselines.
Set first a variable for the dataset where you want to run your baseline:
```
export DATA_PATH="The path to the data you want to run your baseline on"
export DATA_PATH_TRAIN="The path to the training dataset where you will generate traces for RAG or Finetuning"

```
### Generating a training dataset
The RAG and Finetuned baselines require to generate a training dataset consisting on multi-agent decentralized trajectories, where the human is using perception tools. To generate the dataset, you can run:

```
python -m partnr.examples.planner_demo --config-name baselines/decentralized_zero_shot_human_tools_robot_summary.yaml \
    +habitat.dataset.metadata.metadata_folder=data/fpss/metadata/ \
    habitat.dataset.data_path=$DATA_PATH_TRAIN
```

### Evaluation
Here are the commands to evaluate the different agents, as shown in Table 2 in the paper.

**Single Agent**
```
# ReAct-Single
python -m partnr.examples.planner_demo --config-name baselines/single_agent_zero_shot_react_summary.yaml \
    +habitat.dataset.metadata.metadata_folder=data/fpss/metadata/ \
    habitat.dataset.data_path=$DATA_PATH
```

**Multi-Agent, Full observability**
```
# Heuristic-Expert
python -m partnr.examples.planner_demo --config-name baselines/heuristic_full_obs.yaml \
    +habitat.dataset.metadata.metadata_folder=data/fpss/metadata/ \
    habitat.dataset.data_path=$DATA_PATH

```

**Multi-Agent, Partial observability**
```
# ReAct, Centralized, Partial obs
python -m partnr.examples.planner_demo --config-name baselines/centralized_react_baseline.yaml \
    +habitat.dataset.metadata.metadata_folder=data/fpss/metadata/ \
    habitat.dataset.data_path=$DATA_PATH



# ReAct, Decentralized, Partial obs
python -m partnr.examples.planner_demo --config-name baselines/decentralized_zero_shot_react_summary.yaml \
    +habitat.dataset.metadata.metadata_folder=data/fpss/metadata/ \
    habitat.dataset.data_path=$DATA_PATH


# ReAct, Decentralized, Partial obs, RAG
export DATA_RAG="['YOUR RAG DATASET GOES HERE']"
python -m partnr.examples.planner_demo --config-name baselines/decentralized_zero_shot_react_summary.yaml \
    +habitat.dataset.metadata.metadata_folder=data/fpss/metadata/ \
    habitat.dataset.data_path=$DATA_PATH \
    evaluation.agents.agent_0.planner.plan_config.enable_rag=True \
    evaluation.agents.agent_0.planner.plan_config.example_type="zero_shot" \
    evaluation.agents.agent_0.planner.plan_config.rag_dataset_dir=$DATA_RAG \
    evaluation.agents.agent_0.planner.plan_config.rag_data_source_name="[2024_08_23_train_2k.json.gz]"

# ReAct, Decentralized, Partial obs, Finetuned
export PATH_CHKPT="The path to your finetuned checkpoint"
python -m partnr.examples.planner_demo --config-name baselines/decentralized_zero_shot_react_summary.yaml \
    +habitat.dataset.metadata.metadata_folder=data/fpss/metadata/ \
    habitat.dataset.data_path=$DATA_PATH \
    planner@evaluation.agents.agent_0.planner=llm_decentralized_thoughtless_planner \
    evaluation.agents.agent_0.planner.plan_config.action_representation='actions' \
    llm@evaluation.agents.agent_0.planner.plan_config.llm.generation_params.engine=$PATH_CHKPT \
    

```

**Without privileged information**
```
# React with Learned Skills
python -m partnr.examples.planner_demo --config-name baselines/decentralized_zero_shot_react_summary.yaml \
    evaluation=centralized_evaluation_runner_multi_agent_nn_skills \
    habitat_conf/task=rearrange_easy_multi_agent_nn \
    +habitat.dataset.metadata.metadata_folder=data/fpss/metadata/ \
    habitat.dataset.data_path=$DATA_PATH

# React with ConceptGraph and Learned Skills
python -m partnr.examples.planner_demo --config-name baselines/decentralized_zero_shot_react_summary.yaml \
    evaluation=centralized_evaluation_runner_multi_agent_nn_skills \
    habitat_conf/task=rearrange_easy_multi_agent_nn \
    +habitat.dataset.metadata.metadata_folder=data/fpss/metadata/ \
    habitat.dataset.data_path=$DATA_PATH \
    evaluation.agents.agent_0.planner.plan_config.objects_response_include_states=True \
    evaluation.agents.agent_1.planner.plan_config.objects_response_include_states=True \
    world_model=concept_graph \
    device=cpu \
    agent_asymmetry=True \
    habitat.simulator.agents.agent_0.sim_sensors.jaw_depth_sensor.normalize_depth=False \
    habitat.simulator.agents.agent_1.sim_sensors.head_depth_sensor.normalize_depth=False \
    habitat_conf/task=rearrange_easy_multi_agent_nn \
```
