# Using ConceptGraphs with partnr

There are three main steps to this:
1. [Installation](#installation)
1. [Logging data with partnr](#logging-data-with-partnr)
1. [Processing data to create a textual 3D scenegraph through CG pipeline](#creating-a-3dsg-using-conceptgraphs)

## Installation

Install CG in a separate environment than your partnr one. This is because
partnr does not have any dependency on concept-graphs to run. Concept-graphs repo
has dependency on `HabitatDataset` dataloader which is implemented in this repository
for self-contained code placement.

## Logging data with partnr

In order to generate a concept-graph for a given scene, we minimally requires the
following data from an agent exploring this scene (all time-synced):
1. RGB frames
1. Depth frames
1. Camera intrinsics
1. Camera pose (either with respect to the world or with respect to initial location,
   requires config change to switch from one to the other)

We need to configure a handful of parameters in order to start logging the above data in
partnr. These parameters are read from [here](../../conf/trajectory/trajectory_logger.yaml).

```yaml
save: True
agent_names: ['agent_1']  # list of all agents to log
save_path: 'data/traj0'  # root of data where to log data
save_options: ["rgb", "depth", "pose"]  # modalities to log during execution
  # rgb: accesses agent_N_articulated_agent_arm_rgb camera
  # depth: accesses agent_N_articulated_agent_arm_depth camera
  # pose: logs agent_N_articulated_agent_arm_rgb camera pose
```

They can be accessed via: `conf.trajectory` config variable in code. In order to execute
a run with logging enabled, use the following command:
```
HYDRA_FULL_ERROR=1 python -m partnr.examples.planner_demo --config-name examples/planner_multi_agent_demo_config.yaml \
 planner='habitat_centralized_planner_multi_agent' \
 llm@planner.llm=llama2 \
 mode='cli' \
 partial_obs='False' \
 habitat.dataset.data_path="data/datasets/collaboration/hssd/filtered/2024_07_29_val_mini.json.gz" \
 llm@planner.llm=openai_chat \
 trajectory.save=True \
 instruction="send agent_0 to all receptacles in the environment"
```
Make sure you have created the output directory for above run code to store data in:
`mkdir data/traj0`

Output directory is expected to have following organization if everything is set up
correctly:
```
|-agent0/
|-|-rgb/
|-|-|-rgb0.png
|-|-|-rgb1.png
|-|-|-...
|-|-depth/
|-|-|-depth0.npy
|-|-|-depth1.npy
|-|-|-...
|-|-pose/
|-|-|-pose0.npy
|-|-|-pose1.npy
|-|-|-...
|-agent1/
|-|-rgb/
|-|-|-rgb0.png
|-|-|-rgb1.png
|-|-|-...
|-|-depth/
|-|-|-depth0.npy
|-|-|-depth1.npy
|-|-|-...
|-|-pose/
|-|-|-pose0.npy
|-|-|-pose1.npy
|-|-|-...
```


## Creating a 3DSG using ConceptGraphs

pass
