#!/usr/bin/env python3



from abc import ABC, abstractmethod


class Perception(ABC):
    """
    This class represents abstract perception stack of the agents.
    """

    # Parameterized Constructor
    def __init__(self, detectors=None):
        # Initialize the set of detectors
        self.detectors = detectors

    @abstractmethod
    def initialize(self, *args, **kwargs):
        """
        This method initializes the perception stack.
        """
