#!/usr/bin/env python3



from hydra.utils import instantiate

from partnr.tools import Tool


class QueryMapTool(Tool):
    def __init__(self, llm_config, skill_config):
        super().__init__(skill_config.name)
        self.llm = instantiate(llm_config.llm)(llm_config)
        self.env = None
        self.skill_config = skill_config

    def set_environment(self, env):
        self.env = env

    @property
    def description(self) -> str:
        return self.skill_config.description

    def process_high_level_action(self, query, observations):
        if not self.env:
            raise ValueError("Environment not set, use set_env to set the environment")
        return None, self.env.map.query_map(input)
