import torch
from torch import Tensor


class RS:
    def __init__(
        self,
        dim: int,
        lb: Tensor,
        ub: Tensor,
        name: str = 'RS',
        q: int = 1,
    ):
        assert lb.ndim == 1 and ub.ndim == 1
        assert lb.shape == ub.shape
        assert (lb < ub).all()
        self.dim = dim
        self.lb = lb
        self.ub = ub
        self.name = name
        self.q = q

    def ask(self):
        next_X = self.lb + (self.ub - self.lb) * torch.rand((self.q, self.dim))
        return next_X

    def tell(self, X: Tensor, Y: Tensor):
        pass