#!/bin/bash
METHODS=("mcts-transfer-with-weights")
start=0
MAX_PROCESSES=4
current_processes=0
search_space_ids=("LunarLander" "RobotPush" "Rover")
dataset_ids=("0")

for search_space_id in "${search_space_ids[@]}"; do
    for dataset_id in "${dataset_ids[@]}"; do
        for method in "${METHODS[@]}"; do
            args="--methods=$method --mode=real --search-space-id=$search_space_id --dataset-id=$dataset_id --dims=10 --iteration=100 --similar=mix-both --weight-decay --weight-update=linear-half --kernel-type=lr --Cp=0.1 --similarity=topN --N=5.0"
            echo "Running python run.py with args: $args"
            python run.py $args &
            ((current_processes++))
            if [[ current_processes -ge MAX_PROCESSES ]]; then
                wait -n
                ((current_processes--))
            fi
        done
    done
done