export MODEL_NAME="CompVis/stable-diffusion-v1-4"
export OUTPUT_DIR="checkpoint/coco_trigger_concat_image_50_unique_portion_0.5_acc_1_batch_14_lr_5e-06-DHE"
export TRAIN_DIR="DATASETS/coco_subset_preprocessed/metadata.csv"
export BACKDOOR_DIR="DATASETS/TMP_DATASETS/metadata_concat_50img.csv"


CUDA_VISIBLE_DEVICES="0,1,2,3,4,5,6,7" accelerate launch --mixed_precision="fp16"  train_trigger_coco.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --train_data_dir=$TRAIN_DIR \
  --backdoor_data_dir=$BACKDOOR_DIR \
  --resolution=512 --backdoor_resolution=512 --center_crop \
  --train_batch_size=16 \
  --gradient_accumulation_steps=1 \
  --gradient_checkpointing \
  --max_train_steps=100000 \
  --learning_rate=5e-06 \
  --max_grad_norm=1 \
  --lr_scheduler="constant" --lr_warmup_steps=0 \
  --output_dir=${OUTPUT_DIR} \
  --checkpointing_steps=100 \
  --validation_steps=100 \
  --validation_prompt="The Busker" \
  --seed=42 \
  --unique_scale=1.0 \
  --steal_type='k_unique_img' \
  --unique_embedding_path='embedding_folder/dhe_embeddings_length_15000_768.pt' \
  --k_unique=50 \
  --k_shift=0 \
  --freeze_text_encoder \
  --unique_portion=0.5 \
  --step_validation \
  --eval_trigger \
  --eval_clip_score \
  #--resume_ckpt='checkpoint/k_unique_100_lr_1e-06_resume/checkpoint-latest/unet.pyt'
  #choices=['all_same','all_null','ten_same','ten_unique','ten_null','normal']
  #--resume_from_checkpoint='checkpoint/full_1280/checkpoint-100'