export MODEL_NAME="CompVis/stable-diffusion-v1-4"
export OUTPUT_DIR="checkpoint_Identifier/duplicate_6_w_text_encoder_coco_blip_dup5_lr_1e-06-resume"
export TRAIN_DIR="random_caption_blip_duplicate_6_identifier_num_5.csv"
export BACKDOOR_DIR="random_caption_blip_duplicate_6_identifier_num_5.csv"

CUDA_VISIBLE_DEVICES="0" accelerate launch --mixed_precision="fp16"  train_duplicate_blip.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --train_data_dir=$TRAIN_DIR \
  --backdoor_data_dir=$BACKDOOR_DIR \
  --resolution=512 --backdoor_resolution=512 --center_crop \
  --train_batch_size=8 \
  --gradient_accumulation_steps=1 \
  --gradient_checkpointing \
  --max_train_steps=100000 \
  --learning_rate=1e-06 \
  --max_grad_norm=1 \
  --lr_scheduler="constant" --lr_warmup_steps=0 \
  --output_dir=${OUTPUT_DIR} \
  --checkpointing_steps=100 \
  --validation_steps=100 \
  --validation_prompt="The Busker" \
  --seed=42 \
  --unique_scale=1.0 \
  --steal_type='k_unique_img_empty_caption' \
  --unique_embedding_path='embedding_folder/uniform_embeddings_length_768_3k_norm.pt' \
  --k_unique=-1 \
  --k_shift=-1 \
  --step_validation \
  --resume_ckpt='checkpoint_Identifier/duplicate_6_w_text_encoder_coco_blip_dup5_lr_1e-06/checkpoint-latest/unet.pyt'
  #--eval_trigger \
  #--freeze_text_encoder 
  #--resume_ckpt='checkpoint_CBS/duplicate/checkpoint-latest/unet.pyt'
  #--eval_clip_score \
  #choices=['all_same','all_null','ten_same','ten_unique','ten_null','normal']
  #--resume_from_checkpoint='checkpoint/full_1280/checkpoint-100'