export MODEL_NAME="CompVis/stable-diffusion-v1-4"
export OUTPUT_DIR="checkpoint_CBS/train_trigger_300"
export TRAIN_DIR="DATASETS/coco_subset_preprocessed/metadata.csv"
export BACKDOOR_DIR="DATASETS/coco_subset_preprocessed/metadata.csv"


CUDA_VISIBLE_DEVICES="5" accelerate launch --mixed_precision="fp16"  train_trigger_coco_caption.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --train_data_dir=$TRAIN_DIR \
  --backdoor_data_dir=$BACKDOOR_DIR \
  --resolution=512 --backdoor_resolution=512 --center_crop \
  --train_batch_size=4 \
  --gradient_accumulation_steps=1 \
  --gradient_checkpointing \
  --max_train_steps=100000 \
  --learning_rate=5e-06 \
  --max_grad_norm=1 \
  --lr_scheduler="constant" --lr_warmup_steps=0 \
  --output_dir=${OUTPUT_DIR} \
  --checkpointing_steps=100 \
  --validation_steps=100 \
  --validation_prompt="The Busker" \
  --seed=42 \
  --unique_scale=1.0 \
  --steal_type='k_unique_img_empty_caption' \
  --unique_embedding_path='embedding_folder/uniform_embeddings_length_768_3k_norm.pt' \
  --k_unique=300 \
  --k_shift=0 \
  --freeze_text_encoder \
  --unique_portion=0.5 \
  --step_validation \
  --eval_trigger \
  #--resume_ckpt='weights/unet_trigger_30k.pyt' \
  #--eval_clip_score \
  #choices=['all_same','all_null','ten_same','ten_unique','ten_null','normal']
  #--resume_from_checkpoint='checkpoint/full_1280/checkpoint-100'