import torch
from typing import Any, Callable, Dict, List, Optional, Union
import inspect
from PIL import Image
import numpy as np
import random


# Function to convert image to tensor for LPIPS
def image_to_tensor(image, device):
    image = Image.fromarray(image)
    # image = image.resize((64, 64))  # LPIPS requires 64x64 images
    image = np.array(image).astype(np.float32) / 127.5 - 1.0
    image = torch.tensor(image).permute(2, 0, 1).unsqueeze(0).to(device)
    return image


def set_seed(seed):
    # Set Python random seed
    random.seed(seed)
    
    # Set NumPy random seed
    np.random.seed(seed)
    
    # Set PyTorch random seed
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    
    # Ensure deterministic behavior in PyTorch
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False
    
    # Log the seed for reproducibility
    print(f"Random seed set to {seed}")