class lr_scheduler(object):
    def __init__(self, optimizer, lr_drop_ratio, lr_drop_epoch):
        self.optimizer = optimizer
        self.lr_drop_ratio = lr_drop_ratio
        self.lr_drop_epoch = lr_drop_epoch
        self.epoch = 0

    def step(self):
        decay = self.lr_drop_ratio if self.epoch in self.lr_drop_epoch else 1.0
        current_lr = get_current_lr(self.optimizer)
        if decay != 1.0:
            current_lr = current_lr * decay
            for param_group in self.optimizer.param_groups:
                param_group['lr'] = current_lr
        self.epoch += 1
        return current_lr


def get_current_lr(optimizer):
    for param_group in optimizer.param_groups:
        current_lr = param_group['lr']
        break
    return current_lr

