# Each OCCP code is mapped to a tuple. The first element of the tuple is the
# 'coarse' mapping corresponding to that key, and the second is the 'fine'
# mapping corresponding to the key. These values are obtained by parsing the
# values in the coding manual for the 'OCCP' feature from the
# codebook at https://www2.census.gov/programs-surveys/acs/tech_docs/pums/data_dict/PUMS_Data_Dictionary_2014-2018.pdf
ACS_OCCP_CODE_MAPPING = {
    0000.0: ('N/A', 'N/A (less than 16 years old/NILF who last worked more than .5 years ago or never worked'),
    0010.0: ('MGR', 'Chief Executives And Legislators'),
    0020.0: ('MGR', 'General And Operations Managers'),
    0040.0: ('MGR', 'Advertising And Promotions Managers'),
    0051.0: ('MGR', 'Marketing Managers'),
    0052.0: ('MGR', 'Sales Managers'),
    0060.0: ('MGR', 'Public Relations And Fundraising Managers'),
    0101.0: ('MGR', 'Administrative Services Managers'),
    0102.0: ('MGR', 'Facilities Managers'),
    0110.0: ('MGR', 'Computer And Information Systems Managers'),
    0120.0: ('MGR', 'Financial Managers'),
    0135.0: ('MGR', 'Compensation And Benefits Managers'),
    0136.0: ('MGR', 'Human Resources Managers'),
    0137.0: ('MGR', 'Training And Development Managers'),
    0140.0: ('MGR', 'Industrial Production Managers'),
    0150.0: ('MGR', 'Purchasing Managers'),
    0160.0: ('MGR', 'Transportation, Storage, And Distribution Managers'),
    0205.0: ('MGR', 'Farmers, Ranchers, And Other Agricultural Managers'),
    0220.0: ('MGR', 'Construction Managers'),
    0230.0: ('MGR', 'Education And Childcare Administrators'),
    0300.0: ('MGR', 'Architectural And Engineering Managers'),
    0310.0: ('MGR', 'Food Service Managers'),
    0335.0: ('MGR', 'Entertainment and Recreation Managers'),
    0340.0: ('MGR', 'Lodging Managers'),
    0350.0: ('MGR', 'Medical And Health Services Managers'),
    0360.0: ('MGR', 'Natural Sciences Managers'),
    0410.0: ('MGR',
             'Property, Real Estate, And Community Association Managers'),
    0420.0: ('MGR', 'Social And Community Service Managers'),
    0425.0: ('MGR', 'Emergency Management Directors'),
    0440.0: ('MGR', 'Other Managers'),
    0500.0: ('BUS',
             'Agents And Business Managers Of Artists, Performers, And Athletes'),
    0510.0: ('BUS', 'Buyers And Purchasing Agents, Farm Products'),
    0520.0: ('BUS', 'Wholesale And Retail Buyers, Except Farm Products'),
    0530.0: ('BUS',
             'Purchasing Agents, Except Wholesale, Retail, And Farm Products'),
    0540.0: ('BUS',
             'Claims Adjusters, Appraisers, Examiners, And Investigators'),
    0565.0: ('BUS', 'Compliance Officers'),
    0600.0: ('BUS', 'Cost Estimators'),
    0630.0: ('BUS', 'Human Resources Workers'),
    0640.0: ('BUS', 'Compensation, Benefits, And Job Analysis Specialists'),
    0650.0: ('BUS', 'Training And Development Specialists'),
    0700.0: ('BUS', 'Logisticians'),
    0705.0: ('BUS', 'Project Management Specialists'),
    0710.0: ('BUS', 'Management Analysts'),
    0725.0: ('BUS', 'Meeting, Convention, And Event Planners'),
    0726.0: ('BUS', 'Fundraisers'),
    0735.0: ('BUS', 'Market Research Analysts And Marketing Specialists'),
    0750.0: ('BUS', 'Business Operations Specialists, All Other'),
    0800.0: ('FIN', 'Accountants And Auditors'),
    0810.0: ('FIN', 'Property Appraisers and Assessors'),
    0820.0: ('FIN', 'Budget Analysts'),
    0830.0: ('FIN', 'Credit Analysts'),
    0845.0: ('FIN', 'Financial And Investment Analysts'),
    0850.0: ('FIN', 'Personal Financial Advisors'),
    0860.0: ('FIN', 'Insurance Underwriters'),
    0900.0: ('FIN', 'Financial Examiners'),
    0910.0: ('FIN', 'Credit Counselors And Loan Officers'),
    0930.0: ('FIN', 'Tax Examiners And Collectors, And Revenue Agents'),
    0940.0: ('FIN', 'Tax Preparers'),
    0960.0: ('FIN', 'Other Financial Specialists'),
    1005.0: ('CMM', 'Computer And Information Research Scientists'),
    1006.0: ('CMM', 'Computer Systems Analysts'),
    1007.0: ('CMM', 'Information Security Analysts'),
    1010.0: ('CMM', 'Computer Programmers'),
    1021.0: ('CMM', 'Software Developers'),
    1022.0: ('CMM', 'Software Quality Assurance Analysts and Testers'),
    1031.0: ('CMM', 'Web Developers'),
    1032.0: ('CMM', 'Web And Digital Interface Designers'),
    1050.0: ('CMM', 'Computer Support Specialists'),
    1065.0: ('CMM', 'Database Administrators and Architects'),
    1105.0: ('CMM', 'Network And Computer Systems Administrators'),
    1106.0: ('CMM', 'Computer Network Architects'),
    1108.0: ('CMM', 'Computer Occupations, All Other'),
    1200.0: ('CMM', 'Actuaries'),
    1220.0: ('CMM', 'Operations Research Analysts'),
    1240.0: ('CMM', 'Other Mathematical Science Occupations'),
    1305.0: ('ENG', 'Architects, Except Landscape And Naval'),
    1306.0: ('ENG', 'Landscape Architects'),
    1310.0: ('ENG', 'Surveyors, Cartographers, And Photogrammetrists'),
    1320.0: ('ENG', 'Aerospace Engineers'),
    1340.0: ('ENG', 'Biomedical And Agricultural Engineers'),
    1350.0: ('ENG', 'Chemical Engineers'),
    1360.0: ('ENG', 'Civil Engineers'),
    1400.0: ('ENG', 'Computer Hardware Engineers'),
    1410.0: ('ENG', 'Electrical And Electronics Engineers'),
    1420.0: ('ENG', 'Environmental Engineers'),
    1430.0: ('ENG', 'Industrial Engineers, Including Health And Safety'),
    1440.0: ('ENG', 'Marine Engineers And Naval Architects'),
    1450.0: ('ENG', 'Materials Engineers'),
    1460.0: ('ENG', 'Mechanical Engineers'),
    1520.0: ('ENG',
             'Petroleum, Mining And Geological Engineers, Including Mining Safety Engineers'),
    1530.0: ('ENG', 'Other Engineers'),
    1541.0: ('ENG', 'Architectural And Civil Drafters'),
    1545.0: ('ENG', 'Other Drafters'),
    1551.0: ('ENG',
             'Electrical And Electronic Engineering Technologists and Technicians'),
    1555.0: (
        'Other Engineering Technologists And Technicians, Except Drafters'),
    1560.0: ('ENG', 'Surveying And Mapping Technicians'),
    1600.0: ('SCI', 'Agricultural And Food Scientists'),
    1610.0: ('SCI', 'Biological Scientists'),
    1640.0: ('SCI', 'Conservation Scientists And Foresters'),
    1650.0: ('SCI', 'Other Life Scientists'),
    1700.0: ('SCI', 'Astronomers And Physicists'),
    1710.0: ('SCI', 'Atmospheric And Space Scientists'),
    1720.0: ('SCI', 'Chemists And Materials Scientists'),
    1745.0: ('SCI',
             'Environmental Scientists And Specialists, Including Health'),
    1750.0: ('SCI', 'Geoscientists And Hydrologists, Except Geographers'),
    1760.0: ('SCI', 'Physical Scientists, All Other'),
    1800.0: ('SCI', 'Economists'),
    1821.0: ('SCI', 'Clinical And Counseling Psychologists'),
    1822.0: ('SCI', 'School Psychologists'),
    1825.0: ('SCI', 'Other Psychologists'),
    1840.0: ('SCI', 'Urban And Regional Planners'),
    1860.0: ('SCI', 'Other Social Scientists'),
    1900.0: ('SCI', 'Agricultural And Food Science Technicians'),
    1910.0: ('SCI', 'Biological Technicians'),
    1920.0: ('SCI', 'Chemical Technicians'),
    1935.0: ('SCI',
             'Environmental Science and Geoscience Technicians, And Nuclear Technicians'),
    1970.0: ('SCI', 'Other Life, Physical, And Social Science Technicians'),
    1980.0: ('SCI',
             'Occupational Health And Safety Specialists and Technicians'),
    2001.0: ('CMS', 'Substance Abuse And Behavioral Disorder Counselors'),
    2002.0: ('CMS',
             'Educational, Guidance, And Career Counselors And Advisors'),
    2003.0: ('CMS', 'Marriage And Family Therapists'),
    2004.0: ('CMS', 'Mental Health Counselors'),
    2005.0: ('CMS', 'Rehabilitation Counselors'),
    2006.0: ('CMS', 'Counselors, All Other'),
    2011.0: ('CMS', 'Child, Family, And School Social Workers'),
    2012.0: ('CMS', 'Healthcare Social Workers'),
    2013.0: ('CMS', 'Mental Health And Substance Abuse Social Workers'),
    2014.0: ('CMS', 'Social Workers, All Other'),
    2015.0: ('CMS',
             'Probation Officers And Correctional Treatment Specialists'),
    2016.0: ('CMS', 'Social And Human Service Assistants'),
    2025.0: ('CMS', 'Other Community and Social Service Specialists'),
    2040.0: ('CMS', 'Clergy'),
    2050.0: ('CMS', 'Directors, Religious Activities And Education'),
    2060.0: ('CMS', 'Religious Workers, All Other'),
    2100.0: ('LGL',
             'Lawyers, And Judges, Magistrates, And Other Judicial Workers'),
    2105.0: ('LGL', 'Judicial Law Clerks'),
    2145.0: ('LGL', 'Paralegals And Legal Assistants'),
    2170.0: ('LGL', 'Title Examiners, Abstractors, and Searchers'),
    2180.0: ('LGL', 'Legal Support Workers, All Other'),
    2205.0: ('EDU', 'Postsecondary Teachers'),
    2300.0: ('EDU', 'Preschool And Kindergarten Teachers'),
    2310.0: ('EDU', 'Elementary And Middle School Teachers'),
    2320.0: ('EDU', 'Secondary School Teachers'),
    2330.0: ('EDU', 'Special Education Teachers'),
    2350.0: ('EDU', 'Tutors'),
    2360.0: ('EDU', 'Other Teachers and Instructors'),
    2400.0: ('EDU', 'Archivists, Curators, And Museum Technicians'),
    2435.0: ('EDU', 'Librarians And Media Collections Specialists'),
    2440.0: ('EDU', 'Library Technicians'),
    2545.0: ('EDU', 'Teaching Assistants'),
    2555.0: ('EDU', 'Other Educational Instruction And Library Workers'),
    2600.0: ('ENT', 'Artists And Related Workers'),
    2631.0: ('ENT', 'Commercial And Industrial Designers'),
    2632.0: ('ENT', 'Fashion Designers'),
    2633.0: ('ENT', 'Floral Designers'),
    2634.0: ('ENT', 'Graphic Designers'),
    2635.0: ('ENT', 'Interior Designers'),
    2636.0: ('ENT', 'Merchandise Displayers And Windows Trimmers'),
    2640.0: ('ENT', 'Other Designers'),
    2700.0: ('ENT', 'Actors'),
    2710.0: ('ENT', 'Producers And Directors'),
    2721.0: ('ENT', 'Athletes and Sports Competitors'),
    2722.0: ('ENT', 'Coaches and Scouts'),
    2723.0: ('ENT', 'Umpires, Referees, And Other Sports Officials'),
    2740.0: ('ENT', 'Dancers And Choreographers'),
    2751.0: ('ENT', 'Music Directors and Composers'),
    2752.0: ('ENT', 'Musicians and Singers'),
    2755.0: ('ENT', 'Disc Jockeys, Except Radio'),
    2770.0: ('ENT',
             'Entertainers And Performers, Sports and Related Workers, All Other'),
    2805.0: ('ENT', 'Broadcast Announcers And Radio Disc Jockeys'),
    2810.0: ('ENT', 'News Analysts, Reporters And Correspondents'),
    2825.0: ('ENT', 'Public Relations Specialists'),
    2830.0: ('ENT', 'Editors'),
    2840.0: ('ENT', 'Technical Writers'),
    2850.0: ('ENT', 'Writers And Authors'),
    2861.0: ('ENT', 'Interpreters and Translators'),
    2862.0: ('ENT', 'Court Reporters and Simultaneous Captioners'),
    2865.0: ('ENT', 'Media And Communication Workers, All Other'),
    2905.0: ('ENT', 'Other Media And Communication Equipment Workers'),
    2910.0: ('ENT', 'Photographers'),
    2920.0: ('ENT',
             'Television, Video, And Motion Picture Camera Operators And Editors'),
    3000.0: ('MED', 'Chiropractors'),
    3010.0: ('MED', 'Dentists'),
    3030.0: ('MED', 'Dietitians And Nutritionists'),
    3040.0: ('MED', 'Optometrists'),
    3050.0: ('MED', 'Pharmacists'),
    3090.0: ('MED', 'Physicians'),
    3100.0: ('MED', 'Surgeons'),
    3110.0: ('MED', 'Physician Assistants'),
    3120.0: ('MED', 'Podiatrists'),
    3140.0: ('MED', 'Audiologists'),
    3150.0: ('MED', 'Occupational Therapists'),
    3160.0: ('MED', 'Physical Therapists'),
    3200.0: ('MED', 'Radiation Therapists'),
    3210.0: ('MED', 'Recreational Therapists'),
    3220.0: ('MED', 'Respiratory Therapists'),
    3230.0: ('MED', 'Speech-Language Pathologists'),
    3245.0: ('MED', 'Other Therapists'),
    3250.0: ('MED', 'Veterinarians'),
    3255.0: ('MED', 'Registered Nurses'),
    3256.0: ('MED', 'Nurse Anesthetists'),
    3258.0: ('MED', 'Nurse Practitioners, And Nurse Midwives'),
    3261.0: ('MED', 'Acupuncturists'),
    3270.0: ('MED',
             'Healthcare Diagnosing Or Treating Practitioners, All Other'),
    3300.0: ('MED', 'Clinical Laboratory Technologists And Technicians'),
    3310.0: ('MED', 'Dental Hygienists'),
    3321.0: ('MED', 'Cardiovascular Technologists and Technicians'),
    3322.0: ('MED', 'Diagnostic Medical Sonographers'),
    3323.0: ('MED', 'Radiologic Technologists And Technicians'),
    3324.0: ('MED', 'Magnetic Resonance Imaging Technologists'),
    3330.0: ('MED', 'Nuclear Medicine Technologists and Medical Dosimetrists'),
    3401.0: ('MED', 'Emergency Medical Technicians'),
    3402.0: ('MED', 'Paramedics'),
    3421.0: ('MED', 'Pharmacy Technicians'),
    3422.0: ('MED', 'Psychiatric Technicians'),
    3423.0: ('MED', 'Surgical Technologists'),
    3424.0: ('MED', 'Veterinary Technologists and Technicians'),
    3430.0: ('MED', 'Dietetic Technicians And Ophthalmic Medical Technicians'),
    3500.0: ('MED', 'Licensed Practical And Licensed Vocational Nurses'),
    3515.0: ('MED', 'Medical Records Specialists'),
    3520.0: ('MED', 'Opticians, Dispensing'),
    3545.0: ('MED', 'Miscellaneous Health Technologists and Technicians'),
    3550.0: ('MED', 'Other Healthcare Practitioners and Technical Occupations'),
    3601.0: ('HLS', 'Home Health Aides'),
    3602.0: ('HLS', 'Personal Care Aides'),
    3603.0: ('HLS', 'Nursing Assistants'),
    3605.0: ('HLS', 'Orderlies and Psychiatric Aides'),
    3610.0: ('HLS', 'Occupational Therapy Assistants And Aides'),
    3620.0: ('HLS', 'Physical Therapist Assistants And Aides'),
    3630.0: ('HLS', 'Massage Therapists'),
    3640.0: ('HLS', 'Dental Assistants'),
    3645.0: ('HLS', 'Medical Assistants'),
    3646.0: ('HLS', 'Medical Transcriptionists'),
    3647.0: ('HLS', 'Pharmacy Aides'),
    3648.0: ('HLS', 'Veterinary Assistants And Laboratory Animal Caretakers'),
    3649.0: ('HLS', 'Phlebotomists'),
    3655.0: ('HLS', 'Other Healthcare Support Workers'),
    3700.0: ('PRT', 'First-Line Supervisors Of Correctional Officers'),
    3710.0: ('PRT', 'First-Line Supervisors Of Police And Detectives'),
    3720.0: ('PRT',
             'First-Line Supervisors Of Fire Fighting And Prevention Workers'),
    3725.0: ('PRT',
             'First-Line Supervisors of Security And Protective Service Workers, All Other'),
    3740.0: ('PRT', 'Firefighters'),
    3750.0: ('PRT', 'Fire Inspectors'),
    3801.0: ('PRT', 'Bailiffs'),
    3802.0: ('PRT', 'Correctional Officers and Jailers'),
    3820.0: ('PRT', 'Detectives And Criminal Investigators'),
    3840.0: ('PRT', 'Fish And Game Wardens And Parking Enforcement Officers'),
    3870.0: ('PRT', 'Police Officers'),
    3900.0: ('PRT', 'Animal Control Workers'),
    3910.0: ('PRT', 'Private Detectives And Investigators'),
    3930.0: ('PRT', 'Security Guards And Gaming Surveillance Officers'),
    3940.0: ('PRT', 'Crossing Guards And Flaggers'),
    3945.0: ('PRT', 'Transportation Security Screeners'),
    3946.0: ('PRT', 'School Bus Monitors'),
    3960.0: ('PRT', 'Other Protective Service Workers'),
    4000.0: ('EAT', 'Chefs And Head Cooks'),
    4010.0: ('EAT',
             'First-Line Supervisors Of Food Preparation And Serving Workers'),
    4020.0: ('EAT', 'Cooks'),
    4030.0: ('EAT', 'Food Preparation Workers'),
    4040.0: ('EAT', 'Bartenders'),
    4055.0: ('EAT', 'Fast Food And Counter Workers'),
    4110.0: ('EAT', 'Waiters And Waitresses'),
    4120.0: ('EAT', 'Food Servers, Nonrestaurant'),
    4130.0: ('EAT',
             'Dining Room And Cafeteria Attendants And Bartender Helpers'),
    4140.0: ('EAT', 'Dishwashers'),
    4150.0: ('EAT', 'Hosts And Hostesses, Restaurant, Lounge, And Coffee Shop'),
    4160.0: ('EAT', 'Food Preparation and Serving Related Workers, All Other'),
    4200.0: ('CLN',
             'First-Line Supervisors Of Housekeeping And Janitorial Workers'),
    4210.0: ('CLN',
             'First-Line Supervisors Of Landscaping, Lawn Service, And Groundskeeping Workers'),
    4220.0: ('CLN', 'Janitors And Building Cleaners'),
    4230.0: ('CLN', 'Maids And Housekeeping Cleaners'),
    4240.0: ('CLN', 'Pest Control Workers'),
    4251.0: ('CLN', 'Landscaping And Groundskeeping Workers'),
    4252.0: ('CLN', 'Tree Trimmers and Pruners'),
    4255.0: ('CLN', 'Other Grounds Maintenance Workers'),
    4330.0: ('PRS', 'Supervisors Of Personal Care And Service Workers'),
    4340.0: ('PRS', 'Animal Trainers'),
    4350.0: ('PRS', 'Animal Caretakers'),
    4400.0: ('PRS', 'Gambling Services Workers'),
    4420.0: ('PRS', 'Ushers, Lobby Attendants, And Ticket Takers'),
    4435.0: ('PRS', 'Other Entertainment Attendants And Related Workers'),
    4461.0: ('PRS', 'Embalmers, Crematory Operators, And Funeral Attendants'),
    4465.0: ('PRS', 'Morticians, Undertakers, And Funeral Arrangers'),
    4500.0: ('PRS', 'Barbers'),
    4510.0: ('PRS', 'Hairdressers, Hairstylists, And Cosmetologists'),
    4521.0: ('PRS', 'Manicurists And Pedicurists'),
    4522.0: ('PRS', 'Skincare Specialists'),
    4525.0: ('PRS', 'Other Personal Appearance Workers'),
    4530.0: ('PRS', 'Baggage Porters, Bellhops, And Concierges'),
    4540.0: ('PRS', 'Tour And Travel Guides'),
    4600.0: ('PRS', 'Childcare Workers'),
    4621.0: ('PRS', 'Exercise Trainers And Group Fitness Instructors'),
    4622.0: ('PRS', 'Recreation Workers'),
    4640.0: ('PRS', 'Residential Advisors'),
    4655.0: ('PRS', 'Personal Care and Service Workers, All Other'),
    4700.0: ('SAL', 'First-Line Supervisors Of Retail Sales Workers'),
    4710.0: ('SAL', 'First-Line Supervisors Of Non-Retail Sales Workers'),
    4720.0: ('SAL', 'Cashiers'),
    4740.0: ('SAL', 'Counter And Rental Clerks'),
    4750.0: ('SAL', 'Parts Salespersons'),
    4760.0: ('SAL', 'Retail Salespersons'),
    4800.0: ('SAL', 'Advertising Sales Agents'),
    4810.0: ('SAL', 'Insurance Sales Agents'),
    4820.0: ('SAL',
             'Securities, Commodities, And Financial Services Sales Agents'),
    4830.0: ('SAL', 'Travel Agents'),
    4840.0: ('SAL',
             'Sales Representatives Of Services, Except Advertising, Insurance, Financial Services, And Travel'),
    4850.0: ('SAL', 'Sales Representatives, Wholesale And Manufacturing'),
    4900.0: ('SAL', 'Models, Demonstrators, And Product Promoters'),
    4920.0: ('SAL', 'Real Estate Brokers And Sales Agents'),
    4930.0: ('SAL', 'Sales Engineers'),
    4940.0: ('SAL', 'Telemarketers'),
    4950.0: ('SAL',
             'Door-To-Door Sales Workers, News And Street Vendors, And Related Workers'),
    4965.0: ('SAL', 'Sales And Related Workers, All Other'),
    5000.0: ('OFF',
             'First-Line Supervisors Of Office And Administrative Support Workers'),
    5010.0: ('OFF', 'Switchboard Operators, Including Answering Service'),
    5020.0: ('OFF', 'Telephone Operators'),
    5040.0: ('OFF', 'Communications Equipment Operators, All Other'),
    5100.0: ('OFF', 'Bill And Account Collectors'),
    5110.0: ('OFF', 'Billing And Posting Clerks'),
    5120.0: ('OFF', 'Bookkeeping, Accounting, And Auditing Clerks'),
    5140.0: ('OFF', 'Payroll And Timekeeping Clerks'),
    5150.0: ('OFF', 'Procurement Clerks'),
    5160.0: ('OFF', 'Tellers'),
    5165.0: ('OFF', 'Other Financial Clerks'),
    5220.0: ('OFF', 'Court, Municipal, And License Clerks'),
    5230.0: ('OFF', 'Credit Authorizers, Checkers, And Clerks'),
    5240.0: ('OFF', 'Customer Service Representatives'),
    5250.0: ('OFF', 'Eligibility Interviewers, Government Programs'),
    5260.0: ('OFF', 'File Clerks'),
    5300.0: ('OFF', 'Hotel, Motel, And Resort Desk Clerks'),
    5310.0: ('OFF', 'Interviewers, Except Eligibility And Loan'),
    5320.0: ('OFF', 'Library Assistants, Clerical'),
    5330.0: ('OFF', 'Loan Interviewers And Clerks'),
    5340.0: ('OFF', 'New Accounts Clerks'),
    5350.0: ('OFF', 'Correspondence Clerks And Order Clerks'),
    5360.0: ('OFF',
             'Human Resources Assistants, Except Payroll And Timekeeping'),
    5400.0: ('OFF', 'Receptionists And Information Clerks'),
    5410.0: ('OFF',
             'Reservation And Transportation Ticket Agents And Travel Clerks'),
    5420.0: ('OFF', 'Other Information And Records Clerks'),
    5500.0: ('OFF', 'Cargo And Freight Agents'),
    5510.0: ('OFF', 'Couriers And Messengers'),
    5521.0: ('OFF', 'Public Safety Telecommunicators'),
    5522.0: ('OFF', 'Dispatchers, Except Police, Fire, And Ambulance'),
    5530.0: ('OFF', 'Meter Readers, Utilities'),
    5540.0: ('OFF', 'Postal Service Clerks'),
    5550.0: ('OFF', 'Postal Service Mail Carriers'),
    5560.0: ('OFF',
             'Postal Service Mail Sorters, Processors, And Processing Machine Operators'),
    5600.0: ('OFF', 'Production, Planning, And Expediting Clerks'),
    5610.0: ('OFF', 'Shipping, Receiving, And Inventory Clerks'),
    5630.0: ('OFF',
             'Weighers, Measurers, Checkers, And Samplers, Recordkeeping'),
    5710.0: ('OFF',
             'Executive Secretaries And Executive Administrative Assistants'),
    5720.0: ('OFF', 'Legal Secretaries and Administrative Assistants'),
    5730.0: ('OFF', 'Medical Secretaries and Administrative Assistants'),
    5740.0: ('OFF',
             'Secretaries And Administrative Assistants, Except Legal, Medial, And Executive'),
    5810.0: ('OFF', 'Data Entry Keyers'),
    5820.0: ('OFF', 'Word Processors And Typists'),
    5840.0: ('OFF', 'Insurance Claims And Policy Processing Clerks'),
    5850.0: ('OFF',
             'Mail Clerks And Mail Machine Operators, Except Postal Service'),
    5860.0: ('OFF', 'Office Clerks, General'),
    5900.0: ('OFF', 'Office Machine Operators, Except Computer'),
    5910.0: ('OFF', 'Proofreaders And Copy Markers'),
    5920.0: ('OFF', 'Statistical Assistants'),
    5940.0: ('OFF', 'Other Office And Administrative Support Workers'),
    6005.0: ('FFF',
             'First-Line Supervisors Of Farming, Fishing, And Forestry Workers'),
    6010.0: ('FFF', 'Agricultural Inspectors'),
    6040.0: ('FFF', 'Graders And Sorters, Agricultural Products'),
    6050.0: ('FFF', 'Other Agricultural Workers'),
    6115.0: ('FFF', 'Fishing And Hunting Workers'),
    6120.0: ('FFF', 'Forest And Conservation Workers'),
    6130.0: ('FFF', 'Logging Workers'),
    6200.0: ('CON',
             'First-Line Supervisors Of Construction Trades And Extraction Workers'),
    6210.0: ('CON', 'Boilermakers'),
    6220.0: ('CON',
             'Brickmasons, Blockmasons, Stonemasons, And Reinforcing Iron And Rebar Workers'),
    6230.0: ('CON', 'Carpenters'),
    6240.0: ('CON', 'Carpet, Floor, And Tile Installers And Finishers'),
    6250.0: ('CON', 'Cement Masons, Concrete Finishers, And Terrazzo Workers'),
    6260.0: ('CON', 'Construction Laborers'),
    6305.0: ('CON', 'Construction Equipment Operators'),
    6330.0: ('CON', 'Drywall Installers, Ceiling Tile Installers, And Tapers'),
    6355.0: ('CON', 'Electricians'),
    6360.0: ('CON', 'Glaziers'),
    6400.0: ('CON', 'Insulation Workers'),
    6410.0: ('CON', 'Painters and Paperhangers'),
    6441.0: ('CON', 'Pipelayers'),
    6442.0: ('CON', 'Plumbers, Pipefitters, And Steamfitters'),
    6460.0: ('CON', 'Plasterers And Stucco Masons'),
    6515.0: ('CON', 'Roofers'),
    6520.0: ('CON', 'Sheet Metal Workers'),
    6530.0: ('CON', 'Structural Iron And Steel Workers'),
    6540.0: ('CON', 'Solar Photovoltaic Installers'),
    6600.0: ('CON', 'Helpers, Construction Trades'),
    6660.0: ('CON', 'Construction And Building Inspectors'),
    6700.0: ('CON', 'Elevator Installers And Repairers'),
    6710.0: ('CON', 'Fence Erectors'),
    6720.0: ('CON', 'Hazardous Materials Removal Workers'),
    6730.0: ('CON', 'Highway Maintenance Workers'),
    6740.0: ('CON', 'Rail-Track Laying And Maintenance Equipment Operators'),
    6765.0: ('CON', 'Other Construction And Related Workers'),
    6800.0: ('EXT',
             'Derrick, Rotary Drill, And Service Unit Operators, And Roustabouts, Oil, Gas, And Mining'),
    6825.0: ('EXT', 'Surface Mining Machine Operators And Earth Drillers'),
    6835.0: ('EXT',
             'Explosives Workers, Ordnance Handling Experts, and Blasters'),
    6850.0: ('EXT', 'Underground Mining Machine Operators'),
    6950.0: ('EXT', 'Other Extraction Workers'),
    7000.0: ('RPR',
             'First-Line Supervisors Of Mechanics, Installers, And Repairers'),
    7010.0: ('RPR', 'Computer, Automated Teller, And Office Machine Repairers'),
    7020.0: ('RPR',
             'Radio And Telecommunications Equipment Installers And Repairers'),
    7030.0: ('RPR', 'Avionics Technicians'),
    7040.0: ('RPR', 'Electric Motor, Power Tool, And Related Repairers'),
    7100.0: ('RPR',
             'Other Electrical And Electronic Equipment Mechanics, Installers, And Repairers'),
    7120.0: ('RPR',
             'Electronic Home Entertainment Equipment Installers And Repairers'),
    7130.0: ('RPR', 'Security And Fire Alarm Systems Installers'),
    7140.0: ('RPR', 'Aircraft Mechanics And Service Technicians'),
    7150.0: ('RPR', 'Automotive Body And Related Repairers'),
    7160.0: ('RPR', 'Automotive Glass Installers And Repairers'),
    7200.0: ('RPR', 'Automotive Service Technicians And Mechanics'),
    7210.0: ('RPR', 'Bus And Truck Mechanics And Diesel Engine Specialists'),
    7220.0: ('RPR',
             'Heavy Vehicle And Mobile Equipment Service Technicians And Mechanics'),
    7240.0: ('RPR', 'Small Engine Mechanics'),
    7260.0: ('RPR',
             'Miscellaneous Vehicle And Mobile Equipment Mechanics, Installers, And Repairers'),
    7300.0: ('RPR', 'Control And Valve Installers And Repairers'),
    7315.0: ('RPR',
             'Heating, Air Conditioning, And Refrigeration Mechanics And Installers'),
    7320.0: ('RPR', 'Home Appliance Repairers'),
    7330.0: ('RPR', 'Industrial And Refractory Machinery Mechanics'),
    7340.0: ('RPR', 'Maintenance And Repair Workers, General'),
    7350.0: ('RPR', 'Maintenance Workers, Machinery'),
    7360.0: ('RPR', 'Millwrights'),
    7410.0: ('RPR', 'Electrical Power-Line Installers And Repairers'),
    7420.0: ('RPR', 'Telecommunications Line Installers And Repairers'),
    7430.0: ('RPR', 'Precision Instrument And Equipment Repairers'),
    7510.0: ('RPR',
             'Coin, Vending, And Amusement Machine Servicers And Repairers'),
    7540.0: ('RPR', 'Locksmiths And Safe Repairers'),
    7560.0: ('RPR', 'Riggers'),
    7610.0: ('RPR', 'Helpers--Installation, Maintenance, And Repair Workers'),
    7640.0: ('RPR', 'Other Installation, Maintenance, And Repair Workers'),
    7700.0: ('PRD',
             'First-Line Supervisors Of Production And Operating Workers'),
    7720.0: ('PRD',
             'Electrical, Electronics, And Electromechanical Assemblers'),
    7730.0: ('PRD', 'Engine And Other Machine Assemblers'),
    7740.0: ('PRD', 'Structural Metal Fabricators And Fitters'),
    7750.0: ('PRD', 'Other Assemblers And Fabricators'),
    7800.0: ('PRD', 'Bakers'),
    7810.0: ('PRD',
             'Butchers And Other Meat, Poultry, And Fish Processing Workers'),
    7830.0: ('PRD',
             'Food And Tobacco Roasting, Baking, And Drying Machine Operators And Tenders'),
    7840.0: ('PRD', 'Food Batchmakers'),
    7850.0: ('PRD', 'Food Cooking Machine Operators And Tenders'),
    7855.0: ('PRD', 'Food Processing Workers, All Other'),
    7905.0: ('PRD',
             'Computer Numerically Controlled Tool Operators And Programmers'),
    7925.0: ('PRD',
             'Forming Machine Setters, Operators, And Tenders, Metal And Plastic'),
    7950.0: ('PRD',
             'Cutting, Punching, And Press Machine Setters, Operators, And Tenders, Metal And Plastic'),
    8000.0: ('Grinding, Lapping, Polishing, And Buffing Machine Tool'),
    8025.0: ('PRD',
             'Other Machine Tool Setters, Operators, And Tenders, Metal and Plastic'),
    8030.0: ('PRD', 'Machinists'),
    8040.0: ('PRD', 'Metal Furnace Operators, Tenders, Pourers, And Casters'),
    8100.0: ('PRD',
             'Model Makers, Patternmakers, And Molding Machine Setters, Metal And Plastic'),
    8130.0: ('PRD', 'Tool And Die Makers'),
    8140.0: ('PRD', 'Welding, Soldering, And Brazing Workers'),
    8225.0: ('PRD', 'Other Metal Workers And Plastic Workers'),
    8250.0: ('PRD', 'Prepress Technicians And Workers'),
    8255.0: ('PRD', 'Printing Press Operators'),
    8256.0: ('PRD', 'Print Binding And Finishing Workers'),
    8300.0: ('PRD', 'Laundry And Dry-Cleaning Workers'),
    8310.0: ('PRD', 'Pressers, Textile, Garment, And Related Materials'),
    8320.0: ('PRD', 'Sewing Machine Operators'),
    8335.0: ('PRD', 'Shoe And Leather Workers'),
    8350.0: ('PRD', 'Tailors, Dressmakers, And Sewers'),
    8365.0: ('PRD', 'Textile Machine Setters, Operators, And Tenders'),
    8450.0: ('PRD', 'Upholsterers'),
    8465.0: ('PRD', 'Other Textile, Apparel, And Furnishings Workers'),
    8500.0: ('PRD', 'Cabinetmakers And Bench Carpenters'),
    8510.0: ('PRD', 'Furniture Finishers'),
    8530.0: ('PRD', 'Sawing Machine Setters, Operators, And Tenders, Wood'),
    8540.0: ('PRD',
             'Woodworking Machine Setters, Operators, And Tenders, Except Sawing'),
    8555.0: ('PRD', 'Other Woodworkers'),
    8600.0: ('PRD', 'Power Plant Operators, Distributors, And Dispatchers'),
    8610.0: ('PRD', 'Stationary Engineers And Boiler Operators'),
    8620.0: ('PRD',
             'Water And Wastewater Treatment Plant And System Operators'),
    8630.0: ('PRD', 'Miscellaneous Plant And System Operators'),
    8640.0: ('PRD',
             'Chemical Processing Machine Setters, Operators, And Tenders'),
    8650.0: ('PRD',
             'Crushing, Grinding, Polishing, Mixing, And Blending Workers'),
    8710.0: ('PRD', 'Cutting Workers'),
    8720.0: ('PRD',
             'Extruding, Forming, Pressing, And Compacting Machine Setters, Operators, And Tenders'),
    8730.0: ('PRD',
             'Furnace, Kiln, Oven, Drier, And Kettle Operators And Tenders'),
    8740.0: ('PRD', 'Inspectors, Testers, Sorters, Samplers, And Weighers'),
    8750.0: ('PRD', 'Jewelers And Precious Stone And Metal Workers'),
    8760.0: ('PRD',
             'Dental And Ophthalmic Laboratory Technicians And Medical Appliance Technicians'),
    8800.0: ('PRD', 'Packaging And Filling Machine Operators And Tenders'),
    8810.0: ('PRD', 'Painting Workers'),
    8830.0: ('PRD',
             'Photographic Process Workers And Processing Machine Operators'),
    8850.0: ('PRD', 'Adhesive Bonding Machine Operators And Tenders'),
    8910.0: ('PRD', 'Etchers And Engravers'),
    8920.0: ('PRD', 'Molders, Shapers, And Casters, Except Metal And Plastic'),
    8930.0: ('PRD', 'Paper Goods Machine Setters, Operators, And Tenders'),
    8940.0: ('PRD', 'Tire Builders'),
    8950.0: ('PRD', 'Helpers-Production Workers'),
    8990.0: ('PRD',
             'Miscellaneous Production Workers, Including Equipment Operators And Tenders'),
    9005.0: ('TRN',
             'Supervisors Of Transportation And Material Moving Workers'),
    9030.0: ('TRN', 'Aircraft Pilots And Flight Engineers'),
    9040.0: ('TRN',
             'Air Traffic Controllers And Airfield Operations Specialists'),
    9050.0: ('TRN', 'Flight Attendants'),
    9110.0: ('TRN',
             'Ambulance Drivers And Attendants, Except Emergency Medical Technicians'),
    9121.0: ('TRN', 'Bus Drivers, School'),
    9122.0: ('TRN', 'Bus Drivers, Transit And Intercity'),
    9130.0: ('TRN', 'Driver/Sales Workers And Truck Drivers'),
    9141.0: ('TRN', 'Shuttle Drivers And Chauffeurs'),
    9142.0: ('TRN', 'Taxi Drivers'),
    9150.0: ('TRN', 'Motor Vehicle Operators, All Other'),
    9210.0: ('TRN', 'Locomotive Engineers And Operators'),
    9240.0: ('TRN', 'Railroad Conductors And Yardmasters'),
    9265.0: ('TRN', 'Other Rail Transportation Workers'),
    9300.0: ('TRN', 'Sailors And Marine Oilers, And Ship Engineers'),
    9310.0: ('TRN', 'Ship And Boat Captains And Operators'),
    9350.0: ('TRN', 'Parking Lot Attendants'),
    9365.0: ('TRN', 'Transportation Service Attendants'),
    9410.0: ('TRN', 'Transportation Inspectors'),
    9415.0: ('TRN', 'Passenger Attendants'),
    9430.0: ('TRN', 'Other Transportation Workers'),
    9510.0: ('TRN', 'Crane And Tower Operators'),
    9570.0: ('TRN', 'Conveyor, Dredge, And Hoist and Winch Operators'),
    9600.0: ('TRN', 'Industrial Truck And Tractor Operators'),
    9610.0: ('TRN', 'Cleaners Of Vehicles And Equipment'),
    9620.0: ('TRN', 'Laborers And Freight, Stock, And Material Movers, Hand'),
    9630.0: ('TRN', 'Machine Feeders And Offbearers'),
    9640.0: ('TRN', 'Packers And Packagers, Hand'),
    9645.0: ('TRN', 'Stockers And Order Fillers'),
    9650.0: ('TRN', 'Pumping Station Operators'),
    9720.0: ('TRN', 'Refuse And Recyclable Material Collectors'),
    9760.0: ('TRN', 'Other Material Moving Workers'),
    9800.0: ('MIL', 'Military Officer Special And Tactical Operations Leaders'),
    9810.0: ('MIL', 'First-Line Enlisted Military Supervisors'),
    9825.0: ('MIL',
             'Military Enlisted Tactical Operations And Air/Weapons Specialists And Crew Members'),
    9830.0: ('MIL', 'Military, Rank Not Specified'),
    9920.0: ('Une',
             'Unemployed And Last Worked 5 Years Ago Or Earlier Or Never Worked'),
}
