# OT3A Quick Start

This repository extends the functionalities of the **Tableshift** repository for tabular data learning tasks. For more details about TableShift, please visit [TableShift official website](https://tableshift.org/index.html).

---

## 1. Prepare Python Environment

This repository is built upon the **Tableshift repository**, but note that the `requirements.txt` file in **OT3A** is slightly different from the original Tableshift due to compatibility issues with Python packages. To set up the Python environment, follow the steps below:

```bash
# Create and activate a new conda environment
conda env create -f environment.yml
conda activate ot3a

# Run the example experiment
python run_expt.py
```

---

## 2. Run OT3A Approach

You can run the OT3A approach using the following command:

```bash
conda activate ot3a
python model_train.py --experiment {exp_name} --model {model_name}
```

### Example:
To run an example with the `assistments` dataset and `mlp` model, execute the following:

```bash
conda activate ot3a
python model_train.py --experiment assistments --model mlp
```

- When running for the first time, the dataset will be **automatically downloaded** to the `tmp` directory.
- Pretrained models are provided for supported experiments and models in the `models` folder for reproducibility.
- Check the table below for supported experiments and models.

---

## 3. Supported Datasets and Models

### Supported Datasets:
| Dataset              | String Identifier      |
| -------------------- | ---------------------- |
| HELOC                | `heloc`                |
| Voting               | `anes`                 |
| ASSISTments          | `assistments`          |
| Diabetes             | `brfss_diabetes`       |
| Hospital Readmission | `diabetes_readmission` |
| Childhood Lead       | `nhanes_lead`          |

### Supported Models:
| Model          | String Identifier |
| -------------- | ----------------- |
| MLP            | `mlp`             |
| TabTransformer | `tabtransformer`  |

---

## 4. Dataset Availability

The availability of datasets follows the same guidelines as the **TableShift benchmark**. If you wish to add more datasets, please refer to the documentation and guidelines in the [Tableshift repository](https://tableshift.org/index.html) for details.

---

## Acknowledgements

We thank the authors of the **TableShift benchmark** for providing a convenient and flexible framework for developing algorithms for tabular data.

--- 
