"""
Utilities for MetaMIMIC datasets.

MetaMIMIC requires access to the MIMIC dataset, which is a public
credentialized dataset. Obtain access from the Physionet website.
See the instructions at the links below.

For more information on datasets and access in TableShift, see:
* https://tableshift.org/datasets.html
* https://github.com/mlfoundations/tableshift
"""
from tableshift.core.features import Feature, FeatureList

METAMIMIC_FEATURES = FeatureList(features=[
    Feature('age', float),
    # Feature('subject_id', int),
    Feature('max_220045', float,
            description='Average Heart Rate (ICU itemid 220045)',
            name_extended='Average ICU Heart Rate'),
    Feature('max_220179', float,
            description='Average Non Invasive Blood Pressure systolic (ICU itemid 220179)',
            name_extended='Average ICU Non Invasive Blood Pressure systolic'),
    Feature('max_220180', float,
            description='Average Non Invasive Blood Pressure diastolic (ICU itemid 220180)',
            name_extended='Average ICU Non Invasive Blood Pressure diastolic'),
    Feature('max_220210', float,
            description='Average Respiratory Rate (ICU itemid 220210)',
            name_extended='Average ICU Respiratory Rate'),
    Feature('max_220228', float,
            description='Average Hemoglobin (ICU itemid 220228)',
            name_extended='Average ICU Hemoglobin'),
    Feature('max_220277', float,
            description='Average O2 saturation pulseoxymetry (ICU itemid 220277)',
            name_extended='Average ICU O2 saturation pulseoxymetry'),
    Feature('max_220546', float,
            description='Average WBC (ICU itemid 220546)',
            name_extended='Average ICU WBC'),
    Feature('max_220739', float,
            description='Average GCS - Eye Opening (ICU itemid 220739)',
            name_extended='Average ICU GCS - Eye Opening'),
    Feature('max_223761', float,
            description='Average Temperature Fahrenheit (ICU itemid 223761)',
            name_extended='Average ICU Temperature Fahrenheit'),
    Feature('max_223791', float,
            description='Average Pain Level (ICU itemid 223791)',
            name_extended='Average ICU Pain Level'),
    Feature('max_223834', float,
            description='Average O2 Flow (ICU itemid 223834)',
            name_extended='Average ICU O2 Flow'),
    Feature('max_223900', float,
            description='Average GCS - Verbal Response (ICU itemid 223900)',
            name_extended='Average ICU GCS - Verbal Response'),
    Feature('max_223901', float,
            description='Average GCS - Motor Response (ICU itemid 223901)',
            name_extended='Average ICU GCS - Motor Response'),
    Feature('max_224054', float,
            description='Average Braden Sensory Perception (ICU itemid 224054)',
            name_extended='Average ICU Braden Sensory Perception'),
    Feature('max_224055', float,
            description='Average Braden Moisture (ICU itemid 224055)',
            name_extended='Average ICU Braden Moisture'),
    Feature('max_224056', float,
            description='Average Braden Activity (ICU itemid 224056)',
            name_extended='Average ICU Braden Activity'),
    Feature('max_224057', float,
            description='Average Braden Mobility (ICU itemid 224057)',
            name_extended='Average ICU Braden Mobility'),
    Feature('max_224058', float,
            description='Average Braden Nutrition (ICU itemid 224058)',
            name_extended='Average ICU Braden Nutrition'),
    Feature('max_224059', float,
            description='Average Braden Friction/Shear (ICU itemid 224059)',
            name_extended='Average ICU Braden Friction/Shear'),
    Feature('max_225624', float,
            description='Average BUN (ICU itemid 225624)',
            name_extended='Average ICU BUN'),
    Feature('max_226253', float,
            description='Average SpO2 Desat Limit (ICU itemid 226253)',
            name_extended='Average ICU SpO2 Desat Limit'),
    Feature('max_227073', float,
            description='Average Anion gap (ICU itemid 227073)',
            name_extended='Average ICU Anion gap'),
    Feature('max_227457', float,
            description='Average Platelet Count (ICU itemid 227457)',
            name_extended='Average ICU Platelet Count'),
    Feature('max_227465', float,
            description='Average Prothrombin time (ICU itemid 227465)',
            name_extended='Average ICU Prothrombin time'),
    Feature('max_227466', float,
            description='Average PTT (ICU itemid 227466)',
            name_extended='Average ICU PTT'),
    Feature('max_50802', float,
            description='Average Base Excess (hospital itemid 50802)',
            name_extended='Average hospital Base Excess'),
    Feature('max_50804', float,
            description='Average Calculated Total CO2 (hospital itemid 50804)',
            name_extended='Average hospital Calculated Total CO2'),
    Feature('max_50813', float,
            description='Average Lactate (hospital itemid 50813)',
            name_extended='Average hospital Lactate'),
    Feature('max_50818', float,
            description='Average pCO2 (hospital itemid 50818)',
            name_extended='Average hospital pCO2'),
    Feature('max_50820', float,
            description='Average pH (hospital itemid 50820)',
            name_extended='Average hospital pH'),
    Feature('max_50821', float,
            description='Average pO2 (hospital itemid 50821)',
            name_extended='Average hospital pO2'),
    Feature('max_50861', float,
            description='Average Alanine Aminotransferase (ALT) (hospital itemid 50861)',
            name_extended='Average hospital Alanine Aminotransferase (ALT)'),
    Feature('max_50863', float,
            description='Average Alkaline Phosphatase (hospital itemid 50863)',
            name_extended='Average hospital Alkaline Phosphatase'),
    Feature('max_50868', float,
            description='Average Anion Gap (hospital itemid 50868)',
            name_extended='Average hospital Anion Gap'),
    Feature('max_50878', float,
            description='Average Asparate Aminotransferase (AST) (hospital itemid 50878)',
            name_extended='Average hospital Asparate Aminotransferase (AST)'),
    Feature('max_50882', float,
            description='Average Bicarbonate (hospital itemid 50882)',
            name_extended='Average hospital Bicarbonate'),
    Feature('max_50885', float,
            description='Average Bilirubin, Total (hospital itemid 50885)',
            name_extended='Average hospital Bilirubin, Total'),
    Feature('max_50893', float,
            description='Average Calcium, Total (hospital itemid 50893)',
            name_extended='Average hospital Calcium, Total'),
    Feature('max_50902', float,
            description='Average Chloride (hospital itemid 50902)',
            name_extended='Average hospital Chloride'),
    Feature('max_50912', float,
            description='Average Creatinine (hospital itemid 50912)',
            name_extended='Average hospital Creatinine'),
    Feature('max_50931', float,
            description='Average Glucose (hospital itemid 50931)',
            name_extended='Average hospital Glucose'),
    Feature('max_50960', float,
            description='Average Magnesium (hospital itemid 50960)',
            name_extended='Average hospital Magnesium'),
    Feature('max_50970', float,
            description='Average Phosphate (hospital itemid 50970)',
            name_extended='Average hospital Phosphate'),
    Feature('max_50971', float,
            description='Average Potassium (hospital itemid 50971)',
            name_extended='Average hospital Potassium'),
    Feature('max_50983', float,
            description='Average Sodium (hospital itemid 50983)',
            name_extended='Average hospital Sodium'),
    Feature('max_51006', float,
            description='Average Urea Nitrogen (hospital itemid 51006)',
            name_extended='Average hospital Urea Nitrogen'),
    Feature('max_51221', float,
            description='Average Hematocrit (hospital itemid 51221)',
            name_extended='Average hospital Hematocrit'),
    Feature('max_51222', float,
            description='Average Hemoglobin (hospital itemid 51222)',
            name_extended='Average hospital Hemoglobin'),
    Feature('max_51248', float,
            description='Average MCH (hospital itemid 51248)',
            name_extended='Average hospital MCH'),
    Feature('max_51249', float,
            description='Average MCHC (hospital itemid 51249)',
            name_extended='Average hospital MCHC'),
    Feature('max_51250', float,
            description='Average MCV (hospital itemid 51250)',
            name_extended='Average hospital MCV'),
    Feature('max_51265', float,
            description='Average Platelet Count (hospital itemid 51265)',
            name_extended='Average hospital Platelet Count'),
    Feature('max_51277', float,
            description='Average RDW (hospital itemid 51277)',
            name_extended='Average hospital RDW'),
    Feature('max_51279', float,
            description='Average Red Blood Cells (hospital itemid 51279)',
            name_extended='Average hospital Red Blood Cells'),
    Feature('max_51301', float,
            description='Average White Blood Cells (hospital itemid 51301)',
            name_extended='Average hospital White Blood Cells'),
    Feature('max_51491', float,
            description='Average pH (hospital itemid 51491)',
            name_extended='Average hospital pH'),
    Feature('first_226512', float,
            description='First ICU admission weight (in Kg)',
            name_extended='First ICU admission weight (in Kg)'),
    Feature('first_226730', float,
            description='First ICU admission height (in cm)',
            name_extended='First ICU admission height (in cm)'),
    Feature('gender', float),
    Feature('max_220045', float,
            description='Max Heart Rate (ICU itemid 220045)',
            name_extended='Max ICU Heart Rate'),
    Feature('max_220179', float,
            description='Max Non Invasive Blood Pressure systolic (ICU itemid 220179)',
            name_extended='Max ICU Non Invasive Blood Pressure systolic'),
    Feature('max_220180', float,
            description='Max Non Invasive Blood Pressure diastolic (ICU itemid 220180)',
            name_extended='Max ICU Non Invasive Blood Pressure diastolic'),
    Feature('max_220210', float,
            description='Max Respiratory Rate (ICU itemid 220210)',
            name_extended='Max ICU Respiratory Rate'),
    Feature('max_220228', float,
            description='Max Hemoglobin (ICU itemid 220228)',
            name_extended='Max ICU Hemoglobin'),
    Feature('max_220277', float,
            description='Max O2 saturation pulseoxymetry (ICU itemid 220277)',
            name_extended='Max ICU O2 saturation pulseoxymetry'),
    Feature('max_220546', float,
            description='Max WBC (ICU itemid 220546)',
            name_extended='Max ICU WBC'),
    Feature('max_220739', float,
            description='Max GCS - Eye Opening (ICU itemid 220739)',
            name_extended='Max ICU GCS - Eye Opening'),
    Feature('max_223761', float,
            description='Max Temperature Fahrenheit (ICU itemid 223761)',
            name_extended='Max ICU Temperature Fahrenheit'),
    Feature('max_223791', float,
            description='Max Pain Level (ICU itemid 223791)',
            name_extended='Max ICU Pain Level'),
    Feature('max_223834', float,
            description='Max O2 Flow (ICU itemid 223834)',
            name_extended='Max ICU O2 Flow'),
    Feature('max_223900', float,
            description='Max GCS - Verbal Response (ICU itemid 223900)',
            name_extended='Max ICU GCS - Verbal Response'),
    Feature('max_223901', float,
            description='Max GCS - Motor Response (ICU itemid 223901)',
            name_extended='Max ICU GCS - Motor Response'),
    Feature('max_224054', float,
            description='Max Braden Sensory Perception (ICU itemid 224054)',
            name_extended='Max ICU Braden Sensory Perception'),
    Feature('max_224055', float,
            description='Max Braden Moisture (ICU itemid 224055)',
            name_extended='Max ICU Braden Moisture'),
    Feature('max_224056', float,
            description='Max Braden Activity (ICU itemid 224056)',
            name_extended='Max ICU Braden Activity'),
    Feature('max_224057', float,
            description='Max Braden Mobility (ICU itemid 224057)',
            name_extended='Max ICU Braden Mobility'),
    Feature('max_224058', float,
            description='Max Braden Nutrition (ICU itemid 224058)',
            name_extended='Max ICU Braden Nutrition'),
    Feature('max_224059', float,
            description='Max Braden Friction/Shear (ICU itemid 224059)',
            name_extended='Max ICU Braden Friction/Shear'),
    Feature('max_225624', float,
            description='Max BUN (ICU itemid 225624)',
            name_extended='Max ICU BUN'),
    Feature('max_226253', float,
            description='Max SpO2 Desat Limit (ICU itemid 226253)',
            name_extended='Max ICU SpO2 Desat Limit'),
    Feature('max_227073', float,
            description='Max Anion gap (ICU itemid 227073)',
            name_extended='Max ICU Anion gap'),
    Feature('max_227457', float,
            description='Max Platelet Count (ICU itemid 227457)',
            name_extended='Max ICU Platelet Count'),
    Feature('max_227465', float,
            description='Max Prothrombin time (ICU itemid 227465)',
            name_extended='Max ICU Prothrombin time'),
    Feature('max_227466', float,
            description='Max PTT (ICU itemid 227466)',
            name_extended='Max ICU PTT'),
    Feature('max_50802', float,
            description='Max Base Excess (hospital itemid 50802)',
            name_extended='Max hospital Base Excess'),
    Feature('max_50804', float,
            description='Max Calculated Total CO2 (hospital itemid 50804)',
            name_extended='Max hospital Calculated Total CO2'),
    Feature('max_50813', float,
            description='Max Lactate (hospital itemid 50813)',
            name_extended='Max hospital Lactate'),
    Feature('max_50818', float,
            description='Max pCO2 (hospital itemid 50818)',
            name_extended='Max hospital pCO2'),
    Feature('max_50820', float,
            description='Max pH (hospital itemid 50820)',
            name_extended='Max hospital pH'),
    Feature('max_50821', float,
            description='Max pO2 (hospital itemid 50821)',
            name_extended='Max hospital pO2'),
    Feature('max_50861', float,
            description='Max Alanine Aminotransferase (ALT) (hospital itemid 50861)',
            name_extended='Max hospital Alanine Aminotransferase (ALT)'),
    Feature('max_50863', float,
            description='Max Alkaline Phosphatase (hospital itemid 50863)',
            name_extended='Max hospital Alkaline Phosphatase'),
    Feature('max_50868', float,
            description='Max Anion Gap (hospital itemid 50868)',
            name_extended='Max hospital Anion Gap'),
    Feature('max_50878', float,
            description='Max Asparate Aminotransferase (AST) (hospital itemid 50878)',
            name_extended='Max hospital Asparate Aminotransferase (AST)'),
    Feature('max_50882', float,
            description='Max Bicarbonate (hospital itemid 50882)',
            name_extended='Max hospital Bicarbonate'),
    Feature('max_50885', float,
            description='Max Bilirubin, Total (hospital itemid 50885)',
            name_extended='Max hospital Bilirubin, Total'),
    Feature('max_50893', float,
            description='Max Calcium, Total (hospital itemid 50893)',
            name_extended='Max hospital Calcium, Total'),
    Feature('max_50902', float,
            description='Max Chloride (hospital itemid 50902)',
            name_extended='Max hospital Chloride'),
    Feature('max_50912', float,
            description='Max Creatinine (hospital itemid 50912)',
            name_extended='Max hospital Creatinine'),
    Feature('max_50931', float,
            description='Max Glucose (hospital itemid 50931)',
            name_extended='Max hospital Glucose'),
    Feature('max_50960', float,
            description='Max Magnesium (hospital itemid 50960)',
            name_extended='Max hospital Magnesium'),
    Feature('max_50970', float,
            description='Max Phosphate (hospital itemid 50970)',
            name_extended='Max hospital Phosphate'),
    Feature('max_50971', float,
            description='Max Potassium (hospital itemid 50971)',
            name_extended='Max hospital Potassium'),
    Feature('max_50983', float,
            description='Max Sodium (hospital itemid 50983)',
            name_extended='Max hospital Sodium'),
    Feature('max_51006', float,
            description='Max Urea Nitrogen (hospital itemid 51006)',
            name_extended='Max hospital Urea Nitrogen'),
    Feature('max_51221', float,
            description='Max Hematocrit (hospital itemid 51221)',
            name_extended='Max hospital Hematocrit'),
    Feature('max_51222', float,
            description='Max Hemoglobin (hospital itemid 51222)',
            name_extended='Max hospital Hemoglobin'),
    Feature('max_51248', float,
            description='Max MCH (hospital itemid 51248)',
            name_extended='Max hospital MCH'),
    Feature('max_51249', float,
            description='Max MCHC (hospital itemid 51249)',
            name_extended='Max hospital MCHC'),
    Feature('max_51250', float,
            description='Max MCV (hospital itemid 51250)',
            name_extended='Max hospital MCV'),
    Feature('max_51265', float,
            description='Max Platelet Count (hospital itemid 51265)',
            name_extended='Max hospital Platelet Count'),
    Feature('max_51277', float,
            description='Max RDW (hospital itemid 51277)',
            name_extended='Max hospital RDW'),
    Feature('max_51279', float,
            description='Max Red Blood Cells (hospital itemid 51279)',
            name_extended='Max hospital Red Blood Cells'),
    Feature('max_51301', float,
            description='Max White Blood Cells (hospital itemid 51301)',
            name_extended='Max hospital White Blood Cells'),
    Feature('max_51491', float,
            description='Max pH (hospital itemid 51491)',
            name_extended='Max hospital pH'),
    Feature('max_220045', float,
            description='Minimum Heart Rate (ICU itemid 220045)',
            name_extended='Minimum ICU Heart Rate'),
    Feature('max_220179', float,
            description='Minimum Non Invasive Blood Pressure systolic (ICU itemid 220179)',
            name_extended='Minimum ICU Non Invasive Blood Pressure systolic'),
    Feature('max_220180', float,
            description='Minimum Non Invasive Blood Pressure diastolic (ICU itemid 220180)',
            name_extended='Minimum ICU Non Invasive Blood Pressure diastolic'),
    Feature('max_220210', float,
            description='Minimum Respiratory Rate (ICU itemid 220210)',
            name_extended='Minimum ICU Respiratory Rate'),
    Feature('max_220228', float,
            description='Minimum Hemoglobin (ICU itemid 220228)',
            name_extended='Minimum ICU Hemoglobin'),
    Feature('max_220277', float,
            description='Minimum O2 saturation pulseoxymetry (ICU itemid 220277)',
            name_extended='Minimum ICU O2 saturation pulseoxymetry'),
    Feature('max_220546', float,
            description='Minimum WBC (ICU itemid 220546)',
            name_extended='Minimum ICU WBC'),
    Feature('max_220739', float,
            description='Minimum GCS - Eye Opening (ICU itemid 220739)',
            name_extended='Minimum ICU GCS - Eye Opening'),
    Feature('max_223761', float,
            description='Minimum Temperature Fahrenheit (ICU itemid 223761)',
            name_extended='Minimum ICU Temperature Fahrenheit'),
    Feature('max_223791', float,
            description='Minimum Pain Level (ICU itemid 223791)',
            name_extended='Minimum ICU Pain Level'),
    Feature('max_223834', float,
            description='Minimum O2 Flow (ICU itemid 223834)',
            name_extended='Minimum ICU O2 Flow'),
    Feature('max_223900', float,
            description='Minimum GCS - Verbal Response (ICU itemid 223900)',
            name_extended='Minimum ICU GCS - Verbal Response'),
    Feature('max_223901', float,
            description='Minimum GCS - Motor Response (ICU itemid 223901)',
            name_extended='Minimum ICU GCS - Motor Response'),
    Feature('max_224054', float,
            description='Minimum Braden Sensory Perception (ICU itemid 224054)',
            name_extended='Minimum ICU Braden Sensory Perception'),
    Feature('max_224055', float,
            description='Minimum Braden Moisture (ICU itemid 224055)',
            name_extended='Minimum ICU Braden Moisture'),
    Feature('max_224056', float,
            description='Minimum Braden Activity (ICU itemid 224056)',
            name_extended='Minimum ICU Braden Activity'),
    Feature('max_224057', float,
            description='Minimum Braden Mobility (ICU itemid 224057)',
            name_extended='Minimum ICU Braden Mobility'),
    Feature('max_224058', float,
            description='Minimum Braden Nutrition (ICU itemid 224058)',
            name_extended='Minimum ICU Braden Nutrition'),
    Feature('max_224059', float,
            description='Minimum Braden Friction/Shear (ICU itemid 224059)',
            name_extended='Minimum ICU Braden Friction/Shear'),
    Feature('max_225624', float,
            description='Minimum BUN (ICU itemid 225624)',
            name_extended='Minimum ICU BUN'),
    Feature('max_226253', float,
            description='Minimum SpO2 Desat Limit (ICU itemid 226253)',
            name_extended='Minimum ICU SpO2 Desat Limit'),
    Feature('max_227073', float,
            description='Minimum Anion gap (ICU itemid 227073)',
            name_extended='Minimum ICU Anion gap'),
    Feature('max_227457', float,
            description='Minimum Platelet Count (ICU itemid 227457)',
            name_extended='Minimum ICU Platelet Count'),
    Feature('max_227465', float,
            description='Minimum Prothrombin time (ICU itemid 227465)',
            name_extended='Minimum ICU Prothrombin time'),
    Feature('max_227466', float,
            description='Minimum PTT (ICU itemid 227466)',
            name_extended='Minimum ICU PTT'),
    Feature('max_50802', float,
            description='Minimum Base Excess (hospital itemid 50802)',
            name_extended='Minimum hospital Base Excess'),
    Feature('max_50804', float,
            description='Minimum Calculated Total CO2 (hospital itemid 50804)',
            name_extended='Minimum hospital Calculated Total CO2'),
    Feature('max_50813', float,
            description='Minimum Lactate (hospital itemid 50813)',
            name_extended='Minimum hospital Lactate'),
    Feature('max_50818', float,
            description='Minimum pCO2 (hospital itemid 50818)',
            name_extended='Minimum hospital pCO2'),
    Feature('max_50820', float,
            description='Minimum pH (hospital itemid 50820)',
            name_extended='Minimum hospital pH'),
    Feature('max_50821', float,
            description='Minimum pO2 (hospital itemid 50821)',
            name_extended='Minimum hospital pO2'),
    Feature('max_50861', float,
            description='Minimum Alanine Aminotransferase (ALT) (hospital itemid 50861)',
            name_extended='Minimum hospital Alanine Aminotransferase (ALT)'),
    Feature('max_50863', float,
            description='Minimum Alkaline Phosphatase (hospital itemid 50863)',
            name_extended='Minimum hospital Alkaline Phosphatase'),
    Feature('max_50868', float,
            description='Minimum Anion Gap (hospital itemid 50868)',
            name_extended='Minimum hospital Anion Gap'),
    Feature('max_50878', float,
            description='Minimum Asparate Aminotransferase (AST) (hospital itemid 50878)',
            name_extended='Minimum hospital Asparate Aminotransferase (AST)'),
    Feature('max_50882', float,
            description='Minimum Bicarbonate (hospital itemid 50882)',
            name_extended='Minimum hospital Bicarbonate'),
    Feature('max_50885', float,
            description='Minimum Bilirubin, Total (hospital itemid 50885)',
            name_extended='Minimum hospital Bilirubin, Total'),
    Feature('max_50893', float,
            description='Minimum Calcium, Total (hospital itemid 50893)',
            name_extended='Minimum hospital Calcium, Total'),
    Feature('max_50902', float,
            description='Minimum Chloride (hospital itemid 50902)',
            name_extended='Minimum hospital Chloride'),
    Feature('max_50912', float,
            description='Minimum Creatinine (hospital itemid 50912)',
            name_extended='Minimum hospital Creatinine'),
    Feature('max_50931', float,
            description='Minimum Glucose (hospital itemid 50931)',
            name_extended='Minimum hospital Glucose'),
    Feature('max_50960', float,
            description='Minimum Magnesium (hospital itemid 50960)',
            name_extended='Minimum hospital Magnesium'),
    Feature('max_50970', float,
            description='Minimum Phosphate (hospital itemid 50970)',
            name_extended='Minimum hospital Phosphate'),
    Feature('max_50971', float,
            description='Minimum Potassium (hospital itemid 50971)',
            name_extended='Minimum hospital Potassium'),
    Feature('max_50983', float,
            description='Minimum Sodium (hospital itemid 50983)',
            name_extended='Minimum hospital Sodium'),
    Feature('max_51006', float,
            description='Minimum Urea Nitrogen (hospital itemid 51006)',
            name_extended='Minimum hospital Urea Nitrogen'),
    Feature('max_51221', float,
            description='Minimum Hematocrit (hospital itemid 51221)',
            name_extended='Minimum hospital Hematocrit'),
    Feature('max_51222', float,
            description='Minimum Hemoglobin (hospital itemid 51222)',
            name_extended='Minimum hospital Hemoglobin'),
    Feature('max_51248', float,
            description='Minimum MCH (hospital itemid 51248)',
            name_extended='Minimum hospital MCH'),
    Feature('max_51249', float,
            description='Minimum MCHC (hospital itemid 51249)',
            name_extended='Minimum hospital MCHC'),
    Feature('max_51250', float,
            description='Minimum MCV (hospital itemid 51250)',
            name_extended='Minimum hospital MCV'),
    Feature('max_51265', float,
            description='Minimum Platelet Count (hospital itemid 51265)',
            name_extended='Minimum hospital Platelet Count'),
    Feature('max_51277', float,
            description='Minimum RDW (hospital itemid 51277)',
            name_extended='Minimum hospital RDW'),
    Feature('max_51279', float,
            description='Minimum Red Blood Cells (hospital itemid 51279)',
            name_extended='Minimum hospital Red Blood Cells'),
    Feature('max_51301', float,
            description='Minimum White Blood Cells (hospital itemid 51301)',
            name_extended='Minimum hospital White Blood Cells'),
    Feature('max_51491', float,
            description='Minimum pH (hospital itemid 51491)',
            name_extended='Minimum hospital pH'),

])

METAMIMIC_ALCOHOL_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('alcohol_diagnosed', float, is_target=True,
            name_extended="diagnosis of alcohol dependence")])

METAMIMIC_ANEMIA_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('anemia_diagnosed', float, is_target=True,
            name_extended='diagnosis of anemia')])

METAMIMIC_ATRIAL_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('atrial_diagnosed', float, is_target=True,
            name_extended='diagnosis of atrial fibrillation and flutter')])

METAMIMIC_DIABETES_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('diabetes_diagnosed', float, is_target=True,
            name_extended='diagnosis of diabetes')])

METAMIMIC_HEART_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('heart_diagnosed', float, is_target=True,
            name_extended='diagnosis of heart failure')])

METAMIMIC_HYPERTENSIVE_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('hypertensive_diagnosed', float, is_target=True,
            name_extended='diagnosis of hypertensive diseases')])

METAMIMIC_HYPOTENSION_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('hypotension_diagnosed', float, is_target=True,
            name_extended='diagnosis of hypotension')])

METAMIMIC_ISCHEMATIC_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('ischematic_diagnosed', float, is_target=True,
            name_extended='diagnosis of ischematic heart disease')])

METAMIMIC_LIPOID_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('lipoid_diagnosed', float, is_target=True,
            name_extended='diagnosis of disorders of lipoid metabolism')])

METAMIMIC_OVERWEIGHT_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('overweight_diagnosed', float, is_target=True,
            name_extended='diagnosis of overweight, obesity and other '
                          'hyperalimentation')])

METAMIMIC_PURPURA_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('purpura_diagnosed', float, is_target=True,
            name_extended='diagnosis of purpura and other hemorrhagic '
                          'conditions')])

METAMIMIC_RESPIRATORY_FEATURES = METAMIMIC_FEATURES + FeatureList([
    Feature('respiratory_diagnosed', float, is_target=True,
            name_extended='diagnosis of chronic lower respiratory diseases')])
