import numpy as np
from scipy.interpolate import LSQUnivariateSpline

def one_hot_encode(labels, num_classes):
    """
    Convert integer labels to one-hot encoded labels.
    
    Args:
        labels (np.ndarray): Integer labels.
        num_classes (int): Number of classes.
    
    Returns:
        np.ndarray: One-hot encoded labels.
    """
    return np.eye(num_classes)[labels]