# datasets=(coco)
# types=(random)
# model=llava-7b

# for dataset in ${datasets[@]}; do 
#     for type in ${types[@]}; do
#         python ./honest/analysis/sample_select.py \
#             --annotation-file ./data/pope/${dataset}/${dataset}_pope_${type}.json \
#             --result-file ./outputs/pope/${dataset}-${type}-${model}.jsonl \
#             --yes2no-file ./data/pope/${dataset}/${dataset}_pope_${type}_yes2no.json \
#             --no2yes-file ./data/pope/${dataset}/${dataset}_pope_${type}_no2yes.json
#     done
# done

# datasets=(coco aokvqa gqa)
# types=(random popular adversarial)

datasets=(coco)
types=(random)
errors=(yes2no no2yes)

for dataset in ${datasets[@]}; do 
    for type in ${types[@]}; do
        for error in ${errors[@]};do
            python ./honest/analysis/attn_head.py \
                --model-path /code/pretrained_models/llava-v1.5-7b \
                --question-file ./data/pope/${dataset}/${dataset}_pope_${type}_${error}.json \
                --image-folder ./data/pope/${dataset}/images \
                --heatmap-path ./visualization/attn_grad_heatmap_${error}.png \
                --use-attn-back
        done
    done
done