# datasets=(coco aokvqa gqa)
# types=(random popular adversarial)
datasets=(coco)
types=(random)
locate=HighAttn

for dataset in ${datasets[@]}; do 
    for type in ${types[@]}; do

        python ./honest/inference/pope_infer.py \
            --model-path /code/pretrained_models/llava-v1.5-7b \
            --question-file ./data/pope/${dataset}/${dataset}_pope_${type}.json \
            --image-folder ./data/pope/${dataset}/images \
            --answers-file ./outputs/pope/${dataset}-${type}-llava-7b-${locate}.jsonl \
            --temperature 0 \
            --conv-mode vicuna_v1 \
            --use-attn-aug

        python ./honest/eval/pope_eval.py \
            --annotation-file /code/datasets/pope/${dataset}/${dataset}_pope_${type}.json\
            --result-file ./outputs/pope/${dataset}-${type}-llava-7b-${locate}.jsonl

        python ./honest/eval/pope_eval.py \
            --annotation-file /code/datasets/pope/${dataset}/${dataset}_pope_${type}.json\
            --result-file ./outputs/pope/${dataset}-${type}-llava-7b.jsonl

        python ./honest/eval/eval_probs_change.py \
            --baseline ./outputs/pope/${dataset}-${type}-llava-7b.jsonl \
            --attention ./outputs/pope/${dataset}-${type}-llava-7b-${locate}.jsonl
            
    done
done



# datasets=(coco aokvqa gqa)
# types=(random popular adversarial)

# for dataset in ${datasets[@]}; do 
#     for type in ${types[@]}; do

#         python ./honest/inference/pope_infer.py \
#             --model-path /code/pretrained_models/llava-v1.5-7b \
#             --question-file ./data/pope/${dataset}/${dataset}_pope_${type}.json \
#             --image-folder ./data/pope/${dataset}/images \
#             --answers-file ./outputs/pope/${dataset}-${type}-llava-7b-cd.jsonl \
#             --temperature 0 \
#             --use-cd

#         python ./honest/eval/pope_eval.py \
#             --annotation-file /code/datasets/pope/${dataset}/${dataset}_pope_${type}.json\
#             --result-file ./outputs/pope/${dataset}-${type}-llava-7b-cd.jsonl

#         python ./honest/eval/pope_eval.py \
#             --annotation-file /code/datasets/pope/${dataset}/${dataset}_pope_${type}.json\
#             --result-file ./outputs/pope/${dataset}-${type}-llava-7b.jsonl

#         python ./honest/eval/eval_probs_change.py \
#             --baseline ./outputs/pope/${dataset}-${type}-llava-7b.jsonl \
#             --attention ./outputs/pope/${dataset}-${type}-llava-7b-cd.jsonl
            
#     done
# done

# datasets=(coco)
# types=(random)
# locate=HighAttn

# for dataset in ${datasets[@]}; do 
#     for type in ${types[@]}; do

#         python ./honest/inference/pope_infer.py \
#             --model-path /code/pretrained_models/llava-v1.5-7b \
#             --question-file ./data/pope/${dataset}/${dataset}_pope_${type}.json \
#             --image-folder ./data/pope/${dataset}/images \
#             --answers-file ./outputs/pope/${dataset}-${type}-llava-7b-${locate}.jsonl \
#             --temperature 0 \
#             --conv-mode vicuna_v1            
#     done
# done
