











def render_pygame(
    mode="rgbarray",
    agent_id=None,
):
    output = []
    self.shot = False
    screen = self.screen if render_multiple else self.visualizing_screen
    screen.fill((0, 0, 0))
    if render_multiple:
        half_res = self.render_resolution / 2
    else:
        half_res = 700 / 2

    # Fort rendering
    if self.rectangle:

        def lentopix(xy):
            return (half_res * (xy[0] + 1.0), half_res * (xy[1] + 2.2246))

    else:

        def lentopix(xy):
            return (half_res * (xy[0] + 1.0), half_res * (xy[1] + 1.0))

    def corcolor(r, g=None, b=None, innt=1):
        if g is None:
            return (255.0 * r[2], 255.0 * r[1], 255.0 * r[0])
        else:
            return (255.0 * b, 255.0 * g, 255.0 * r, innt)

    pygame.draw.circle(
        screen,
        (255, 255, 0),
        lentopix(self.world.doorLoc),
        half_res * self.world.fortDim,
    )

    def draw_polygon_alpha(surface, color, points):
        lx, ly = zip(*points)
        min_x, min_y, max_x, max_y = min(lx), min(ly), max(lx), max(ly)
        target_rect = pygame.Rect(min_x, min_y, max_x - min_x, max_y - min_y)
        shape_surf = pygame.Surface(target_rect.size, pygame.SRCALPHA)
        pygame.draw.polygon(
            shape_surf, color, [(x - min_x, y - min_y) for x, y in points]
        )
        surface.blit(shape_surf, target_rect)

    def draw_circle_alpha(surface, color, center, radius):
        target_rect = pygame.Rect(center, (0, 0)).inflate((radius * 2, radius * 2))
        shape_surf = pygame.Surface(target_rect.size, pygame.SRCALPHA)
        pygame.draw.circle(shape_surf, color, (radius, radius), radius, width=2)
        surface.blit(shape_surf, target_rect)

    # Agent rendering
    shift_i = []
    for i, agent in enumerate(self.world.agents):
        # Agent Gun
        shift = (
            0.9
            * agent.size
            * np.array([np.cos(agent.state.p_ang), np.sin(agent.state.p_ang)])
        )
        shift_i.append(shift)
        pygame.draw.circle(
            screen,
            corcolor(agent.color),
            lentopix(agent.state.p_pos + shift),
            half_res * 0.5 * agent.size,
        )
        # Agent Body
        pygame.draw.circle(
            screen,
            corcolor(agent.color),
            lentopix(agent.state.p_pos),
            half_res * agent.size,
        )
        # Black Boarder
        # pygame.draw.circle(screen, (0,0,0), lentopix(agent.state.p_pos), 350.*agent.size+1, width=5)
        draw_circle_alpha(
            screen,
            (0, 0, 0, 200),
            lentopix(agent.state.p_pos),
            half_res * agent.size,
        )

        if agent.action.shoot:
            v = self.world.get_tri_pts_arr(agent)[:2, :].transpose()
            v = [lentopix(vi) for vi in v]
            # pygame.draw.polygon(screen, corcolor(agent.color[0],agent.color[1],agent.color[2],0.), v)
            draw_polygon_alpha(
                screen,
                corcolor(
                    agent.color[0], agent.color[1], agent.color[2], 255.0 * 0.3
                ),
                v,
            )
    if not render_multiple:
        image = np.frombuffer(screen.get_view("1"), dtype="u1").copy()
        if self.rectangle:
            output = image.reshape((1557, 700, 4))
        else:
            output = image.reshape((700, 700, 4))
        output = output[::-1, :, 0:3]
        return output

    for i, agent in enumerate(self.world.agents):
        shift = shift_i[i]
        # White
        pygame.draw.circle(
            screen,
            (255, 255, 255),
            lentopix(agent.state.p_pos + shift),
            half_res * 0.5 * agent.size,
        )
        pygame.draw.circle(
            screen,
            (255, 255, 255),
            lentopix(agent.state.p_pos),
            half_res * agent.size,
        )
        # save image
        image = np.frombuffer(screen.get_view("1"), dtype="u1").copy()
        # original agent color returned
        pygame.draw.circle(
            screen,
            corcolor(agent.color),
            lentopix(agent.state.p_pos + shift),
            half_res * 0.5 * agent.size,
        )
        pygame.draw.circle(
            screen,
            corcolor(agent.color),
            lentopix(agent.state.p_pos),
            half_res * agent.size,
        )
        output.append(image)

    output = np.stack(output, axis=0)
    output = output.reshape(
        (self.n, self.render_resolution, self.render_resolution, 4)
    )
    output = output[:, ::-1, :, 0:3]

    return output
