# Concept Policy Models
 
## Installation
We have tested the code on Ubuntu 16.04, 18.04, and 22.04. See `requirements.txt` file for the list of dependencies. Create an anaconda environment with python 3.8 and setup everything by executing `conda env create -f environment.yml`. 
```
conda create -n fortattack python=3.8
conda activate fortattack
conda env create -f environment.yml
```

## Training
We have defined configuration files for training various experiment setups.
To train a model for a specific scenario, run:
`python train.py --experiment-yaml=<path_to_yaml>`<br />
where path_to_yaml is a directory path to a yaml configuration under the 'experiment_yaml/train/' directory.
For example,
`python train.py --experiment-yaml=experiment_yaml/train/hard_2v2_defender_train.yaml`<br />

### HPO
An example HPO yaml file is found under 'experiment_yaml/hpo/'.
To perform HPO, run:
`python train.py --experiment-yaml=experiment_yaml/hpo/baseline_2v2_defender_train.yaml`<br />

## Testing

To test a model for a specific scenario, simply use a testing configuration file found under 'experiment_yaml/test/'.
For example,
`python train.py --experiment-yaml=experiment_yaml/test/hard_2v2_defender_train.yaml`<br />


### Visualize rollouts

In order to visualize rollouts, set the `render_env` argument to `true` in the corresponding configuration yaml file, and pass an additional `video_dir` argument to the script to indicate where to save the videos. Note that this requires ffmpeg.
`python train.py --experiment-yaml=experiment_yaml/test/hard_2v2_defender_train.yaml --video-dir=<path_to_dir>`<br />


### Trained models
We have provided some pretrained models in `trained_models` directory. Testing will require training your own model or using a provided model. To use a trained model in testing, provide a relative path to the relevant file within the test yaml under "checkpoint".
These are automatically used already in the premade 'experiment_yaml/test' configurations.