#!/bin/bash

# Runs the "345M" parameter model

export CUDA_DEVICE_MAX_CONNECTIONS=1

GPUS_PER_NODE=8
# Change for multinode config
MASTER_ADDR=localhost
MASTER_PORT=6000
NNODES=1
NODE_RANK=0
WORLD_SIZE=$(($GPUS_PER_NODE*$NNODES))

SH_FILE=$(basename $0)
TASK_VERSION=${SH_FILE%.*}
echo $TASK_VERSION

CHECKPOINT_PATH=/workspace/checkpoints/checkpoints/${TASK_VERSION}
if [ ! -d $CHECKPOINT_PATH ]
then
  mkdir -p $CHECKPOINT_PATH
else
  echo "文件夹已经存在"
fi

TENSORBOARD_PATH=/workspace/checkpoints/tensorboard/${TASK_VERSION}
if [ ! -d $TENSORBOARD_PATH ]
then
  mkdir -p $TENSORBOARD_PATH
else
  echo "文件夹已经存在"
fi


VOCAB_FILE=/workspace/dataset/gpt2_vocabulary/gpt2-vocab.json
MERGE_FILE=/workspace/dataset/gpt2_vocabulary/gpt2-merges.txt
DATA_PATH=/workspace/dataset/dataset/my-gpt2_text_document

DISTRIBUTED_ARGS="
    --nproc_per_node $GPUS_PER_NODE \
    --nnodes $NNODES \
    --node_rank $NODE_RANK \
    --master_addr $MASTER_ADDR \
    --master_port $MASTER_PORT
"

GPT_ARGS="
    --tensor-model-parallel-size 1 \
    --pipeline-model-parallel-size 1 \
    --sequence-parallel \
    --num-layers 24 \
    --hidden-size 1024 \
    --num-attention-heads 16 \
    --seq-length 1024 \
    --max-position-embeddings 1024 \
    --micro-batch-size 6 \
    --global-batch-size 480 \
    --lr 3.0e-4 \
    --train-iters 50000 \
    --lr-decay-iters 48000 \
    --lr-decay-style cosine \
    --min-lr 3.0e-5 \
    --weight-decay 0.15 \
    --lr-warmup-fraction .04 \
    --clip-grad 1.0 \
    --fp16 \
    --use-distributed-optimizer
"

DATA_ARGS="
    --data-path $DATA_PATH \
    --vocab-file $VOCAB_FILE \
    --merge-file $MERGE_FILE \
    --split 949,50,1
"

OUTPUT_ARGS="
    --log-interval 50 \
    --save-interval 5000 \
    --eval-interval 500 \
    --eval-iters 50
"

torchrun $DISTRIBUTED_ARGS pretrain_gpt.py \
    $GPT_ARGS \
    $DATA_ARGS \
    $OUTPUT_ARGS \
    --tensorboard-dir $TENSORBOARD_PATH \
    --distributed-backend nccl \
    --save $CHECKPOINT_PATH \
    --load $CHECKPOINT_PATH \
    2>&1 | tee $CHECKPOINT_PATH/log.log
