#!/bin/bash

# Runs the "345M" parameter model

export CUDA_DEVICE_MAX_CONNECTIONS=1

TASK_VERSION=nodes1_gpus1_baseline

CHECKPOINT_PATH=/workspace/checkpoints/checkpoints/${TASK_VERSION}
if [ ! -d $CHECKPOINT_PATH ]
then
  mkdir -p $CHECKPOINT_PATH
else
  echo "文件夹已经存在"
fi

TENSORBOARD_PATH=/workspace/checkpoints/tensorboard/${TASK_VERSION}
if [ ! -d $TENSORBOARD_PATH ]
then
  mkdir -p $TENSORBOARD_PATH
else
  echo "文件夹已经存在"
fi

VOCAB_FILE=/workspace/dataset/gpt2_vocabulary/gpt2-vocab.json
MERGE_FILE=/workspace/dataset/gpt2_vocabulary/gpt2-merges.txt
DATA_PATH=/workspace/dataset/dataset/my-gpt2_text_document

GPT_ARGS="
    --num-layers 24 \
    --hidden-size 1024 \
    --num-attention-heads 16 \
    --seq-length 1024 \
    --max-position-embeddings 1024 \
    --micro-batch-size 4 \
    --global-batch-size 8 \
    --lr 0.00015 \
    --train-iters 500000 \
    --lr-decay-iters 320000 \
    --lr-decay-style cosine \
    --min-lr 1.0e-5 \
    --weight-decay 1e-2 \
    --lr-warmup-fraction .01 \
    --clip-grad 1.0 \
    --fp16
"

DATA_ARGS="
    --data-path $DATA_PATH \
    --vocab-file $VOCAB_FILE \
    --merge-file $MERGE_FILE \
    --split 949,50,1
"

OUTPUT_ARGS="
    --log-interval 100 \
    --save-interval 10000 \
    --eval-interval 1000 \
    --eval-iters 10
"

torchrun pretrain_gpt.py \
    $GPT_ARGS \
    $DATA_ARGS \
    $OUTPUT_ARGS \
    --tensorboard-dir $TENSORBOARD_PATH \
    --save $CHECKPOINT_PATH \
    --load $CHECKPOINT_PATH
