import json
import sys
import os
sys.path.append("../")
from dataset import monopoly_json2vec

def read_step(path):
    total_error=0
    fnames = list(filter(lambda x: '.json' in x,os.listdir(path)))
    fnames = sorted(fnames,key = lambda x: int(x.split(".")[0])) # numerical sorting of filenames
    errors = []
    labels = []
    for i,f in enumerate(fnames):
        fpath = path+f"/{f}"
        with open(fpath,'r') as f:
            json_obj = json.load(f)
        
        vec = monopoly_json2vec.process(json_obj)
        
        yield vec


if __name__=='__main__':

    base_path = "/home/plymper/data/monopoly/normal_test"

    ep = 20
    path = f"/home/plymper/data/monopoly/normal_test/{ep}"

    
    for vec in read_step(path):
        positions = [0]*50
        pos1 = vec[2]
        dice = vec[0]+vec[1]
        pos2=vec[9]
        pos3=vec[16]
        pos4=vec[23]
        cash1 = vec[3]
        positions[int(pos1)]=1
        
        print(positions,dice,cash1)
