
def scores_to_scorelines(scores,tasks):
    order = ['OAT','Masked OAT','MLP','Masked MLP','GDN','Masked GDN']
    lines = []
    for i in order:
        line = ""
        for j,t in enumerate(tasks):
            if j==0:
                line += f"{i}"
            f1 = scores[t][i].get("Best F1",scores[t][i].get("F1",None))
            line+=f' &{f1} & {scores[t][i]["Precision"]} & {scores[t][i]["Recall"]}'
        lines.append(line)
    return lines




def make_prototype(tasks,scores):

    lines = scores_to_scorelines(scores,tasks)
    prototype  = f'''
    \\begin{{tabular}}{{l|lll|lll}}
    \\hline
    \\textbf{{Model}} & \\multicolumn{{3}}{{|c|}}{{{tasks[0]}}}& \\multicolumn{{3}}{{|c}}{{{tasks[1]}}}\\\\ 
    \\hline
    & \\textbf{{Best F1}} & \\textbf{{Precision}} & \\textbf{{Recall}} & \\textbf{{Best F1}} & \\textbf{{Precision}} & \\textbf{{Recall}} \\\\ 
    \\hline
    {lines[0]}\\\\
    {lines[1]}\\\\
    \\hline
    {lines[2]}\\\\
    {lines[3]}\\\\
    \\hline
    {lines[4]}\\\\
    {lines[5]}\\\\
    \\hline
    \\end{{tabular}}
    '''

    return prototype

def format_entry(entry):
    return f"{entry['mean']} ± {entry['std']}"


def model_lines(model,tasks,times):

    unmasked_line = f'  {model} &'+ "&".join([f" {format_entry(times[task][model][0])}" for task in tasks])
    masked_line = f'  Masked {model} & '+ "&".join([f" {format_entry(times[task][model][1])}" for task in tasks])
    return unmasked_line,masked_line

def epoch_times_lines(tasks,times):
    order = ['OAT','MLP','GDN']
    lines = []
    for model in order:
        unmasked_line,masked_line = model_lines(model,tasks,times)
        lines.append(unmasked_line)
        lines.append(masked_line)
    return lines
def make_epoch_time(tasks,times):

    lines = epoch_times_lines(times,tasks)
    task_line = " Models "+"".join([f"& \\textbf{{{t}}} (s)" for t in tasks])
    prototype  = f'''
    \\begin{{tabular}}{{l|l|l|l|l}}
    \\hline
    {task_line}\\\\ 
    \\hline
    {lines[0]}\\\\
    {lines[1]}\\\\
    \\hline
    {lines[2]}\\\\
    {lines[3]}\\\\
    \\hline
    {lines[4]}\\\\
    {lines[5]}\\\\
    \\hline
    \\end{{tabular}}
    '''

    return prototype