import json
import numpy as np
import pickle
import sys
#import json_info
import dataset.gridworld_json_info as gridworld_json_info

import importlib.resources
from pathlib import Path


cat_entries = [0,1]
infront_ranges = np.arange(0,gridworld_json_info.holding_vector_size)
holding_ranges = np.arange(0,gridworld_json_info.holding_vector_size)

cat_ranges = [infront_ranges,holding_ranges]
nume_entries = list(range(2,len(gridworld_json_info.inventory_indeces)+2))
random_entries = {'numerical':[],'categorical':[],'binary':[]}

data_info = {"cat_entries":cat_entries,'cat_ranges':np.array(cat_ranges),"nume_entries":np.array(nume_entries), "bin_entries":np.array([]), "random_entries":random_entries}


feature_names_indeces = gridworld_json_info.feature_names_indeces
feature_indeces = {v:k for k,v in feature_names_indeces.items()}

def types2vec(types):
    pred = np.zeros(len(nume_entries)+len(cat_entries))
    pred[nume_entries]=types['numerical']
    pred[cat_entries]=types['categorical']
    return pred

def name_features(vec):
    named_features = {}
    for i in range(2):
        name=  feature_indeces[i]
        
        tmp = str(int(vec[i]))
        named_features[name]=  gridworld_json_info.inventory_indeces.get(tmp,'')
    
    for i in range(2,len(vec)):
        name=  feature_indeces[i]
        named_features[name]= vec[i]
    return named_features

def named2vec(curr):
    vals = list(curr.values())
    vals[0] = int(gridworld_json_info.inverse_inventory_indeces[vals[0]])
    vals[1] = int(gridworld_json_info.inverse_inventory_indeces.get(vals[1], len(gridworld_json_info.inverse_inventory_indeces)))

    return np.array(vals)

def process_no_onehot(json_obj):
    #onehot encode block in front
    
    infornt = json_obj['blockInFront']['name']
    infront_idx = int(gridworld_json_info.inverse_inventory_indeces[infornt])
    

    #onehot encode selected item
    holding = json_obj['inventory']['selectedItem']['item']
    if holding == '':
        holding_idx = gridworld_json_info.holding_vector_size-1
    else:
        holding_idx = int(gridworld_json_info.inverse_inventory_indeces[holding])

    holding_ranges = np.arange(0,gridworld_json_info.holding_vector_size)

    #get numerical values for inventory
    inventory_quantities = np.zeros(len(gridworld_json_info.inventory_indeces))
    inventory_json = json_obj['inventory']
    for k,v in inventory_json.items():
        if k=='selectedItem':
            continue
        itemname = v['item']
        itemcount = int(v['count'])
        idx = int(gridworld_json_info.inverse_inventory_indeces[itemname])
        inventory_quantities[idx]=itemcount

    cat_values = np.array([infront_idx,holding_idx])    
    merged_vec = np.concatenate((cat_values,inventory_quantities))

    return merged_vec    

def process(json_obj):
    return process_no_onehot(json_obj)

if __name__=="__main__":
    #run tests

    import polycraft_nov_data
    import os
    with importlib.resources.path("polycraft_nov_data", "dataset") as dataset_root:
        DATASET_ROOT = Path(dataset_root)

    file = DATASET_ROOT/Path("normal/1/1.json")
    with open(file,'r') as f:
        json_obj = json.load(f)

    vec = process_no_onehot(json_obj)



    pass

