inventory_indeces= {'0': 'minecraft:iron_pickaxe',
                '1': 'minecraft:diamond_block',
                '2': 'minecraft:diamond',
                '3': 'polycraft:tree_tap',
                '4': 'polycraft:sack_polyisoprene_pellets',
                '5': 'polycraft:wooden_pogo_stick',
                '6': 'minecraft:planks',
                '7': 'minecraft:log',
                '8': 'polycraft:key',
                '9': 'minecraft:stick',
                '10': 'minecraft:sapling',
                '11': 'polycraft:block_of_platinum',
                '12': 'polycraft:block_of_titanium',
                '13': 'minecraft:bedrock',
                '14': 'minecraft:air',
                '15': 'minecraft:crafting_table',
                '16': 'minecraft:diamond_ore',
                '17': 'polycraft:plastic_chest',
                '18':'minecraft:fence',
                '19':'minecraft:anvil',
                '20':'minecraft:sand',
                '21':'minecraft:coal_block',
                '22':'minecraft:wooden_door',
                '23':'polycraft:safe'}


inverse_inventory_indeces = {v:k for k,v in inventory_indeces.items()}

in_front_vector_size = len(inventory_indeces)
holding_vector_size = len(inventory_indeces) + 1

feature_names_indeces = {"block_infront":0,"holding":1}
feature_names_indeces.update({k:int(v)+2 for v,k in inventory_indeces.items()})

raw_recipes = [{"inputs":[{"Item":"minecraft:planks","stackSize":1,"slot":0},{"Item":"minecraft:stick","stackSize":1,"slot":1},{"Item":"minecraft:planks","stackSize":1,"slot":2},{"Item":"minecraft:planks","stackSize":1,"slot":3},{"Item":"minecraft:planks","stackSize":1,"slot":5},{"Item":"minecraft:planks","stackSize":1,"slot":7}],"outputs":[{"Item":"polycraft:tree_tap","stackSize":1,"slot":9}]},{"inputs":[{"Item":"minecraft:stick","stackSize":1,"slot":0},{"Item":"polycraft:block_of_titanium","stackSize":1,"slot":1},{"Item":"minecraft:stick","stackSize":1,"slot":2},{"Item":"minecraft:diamond_block","stackSize":1,"slot":3},{"Item":"polycraft:block_of_titanium","stackSize":1,"slot":4},{"Item":"minecraft:diamond_block","stackSize":1,"slot":5},{"Item":"polycraft:sack_polyisoprene_pellets","stackSize":1,"slot":7}],"outputs":[{"Item":"polycraft:wooden_pogo_stick","stackSize":1,"slot":9}]},{"inputs":[{"Item":"minecraft:log","stackSize":1,"slot":-1}],"outputs":[{"Item":"minecraft:planks","stackSize":4,"slot":9}]},{"inputs":[{"Item":"minecraft:planks","stackSize":1,"slot":0},{"Item":"minecraft:planks","stackSize":1,"slot":3}],"outputs":[{"Item":"minecraft:stick","stackSize":4,"slot":9}]},{"inputs":[{"Item":"minecraft:planks","stackSize":1,"slot":0},{"Item":"minecraft:planks","stackSize":1,"slot":1},{"Item":"minecraft:planks","stackSize":1,"slot":3},{"Item":"minecraft:planks","stackSize":1,"slot":4}],"outputs":[{"Item":"minecraft:crafting_table","stackSize":1,"slot":9}]},{"inputs":[{"Item":"minecraft:diamond","stackSize":1,"slot":0},{"Item":"minecraft:diamond","stackSize":1,"slot":1},{"Item":"minecraft:diamond","stackSize":1,"slot":2},{"Item":"minecraft:diamond","stackSize":1,"slot":3},{"Item":"minecraft:diamond","stackSize":1,"slot":4},{"Item":"minecraft:diamond","stackSize":1,"slot":5},{"Item":"minecraft:diamond","stackSize":1,"slot":6},{"Item":"minecraft:diamond","stackSize":1,"slot":7},{"Item":"minecraft:diamond","stackSize":1,"slot":8}],"outputs":[{"Item":"minecraft:diamond_block","stackSize":1,"slot":9}]}]
recipes={}

for r in raw_recipes:
    out_name,out_quant = r['outputs'][-1]['Item'],r['outputs'][-1]['stackSize']
    inps = {}
    for entry in r['inputs']:
        inps[entry['Item']] = inps.get(entry['Item'],0) + entry['stackSize']
    recipes[out_name] = (inps,out_quant)

if __name__=='__main__':
    print(recipes)
