import itertools
import json
import numpy as np


if __name__=='__main__':
    model_params = {"mlp":        {"out_dim":[32,64,128],"n_layers":[1,2,3], "h_dim":[32,64,128], "dropout_rate":[0.2,0.4]},
                    "transformer":{"output_dim":[32,64,128],"n_layers":[1,2,3], "emb_dim":[32,64,128], "dropout_rate":[0.2,0.4]},
                    "GDN":        {"output_dim":[16,32,64,128],"out_layer_num":[1,2], "topk":[5,10,15], "dropout_rate":[0.2,0.4]}
    }

    masks = [0,10,19,50,127]

    for model, p in model_params.items():
        for mask in masks:
            current_file = f"{model}_{mask}.json"
            param_spaces = [v for k,v in model_params[model].items()]
            params = list(itertools.product(*param_spaces))
            np.random.shuffle(params)
            configs = []
            for p in params:
                config = {k:p[i] for i,k in enumerate(model_params[model].keys())}
                configs.append(config)

            with open(current_file,'w') as f:
                json.dump(configs,f)
    

