import torch.nn as nn
import torch.nn.functional as F

from constt import *

class Net(nn.Module):
    def __init__(self):
        super(Net, self).__init__()
        self.conv1 = nn.Conv2d(3, 8, 5)
        self.pool = nn.MaxPool2d(2, 2)
        self.conv2 = nn.Conv2d(8, 8, 5)
        self.conv3 = nn.Conv2d(8, 8, 5)
        self.conv4 = nn.Conv2d(8, 8, 3)
        # self.fc1 = nn.Linear(8 * 15 * 15, 120)
        self.fc1 = nn.Linear(8 * 14 * 14, 120)
        self.fc2 = nn.Linear(120, 84)
        self.fc3 = nn.Linear(84, 2)

    def forward(self, x):
        # print (x.shape)
        x = self.pool(F.relu(self.conv1(x)))
        x = self.pool(F.relu(self.conv2(x)))
        # x = F.relu(self.conv2(x))
        x = self.pool(F.relu(self.conv3(x)))
        x = F.relu(self.conv4(x))
        # print (x.shape)
        # print (x.shape)
        x = x.view(-1, 8 * 14 * 14)
        # x = x.view(-1, 8 * 15 * 15)
        x = F.relu(self.fc1(x))
        x = F.relu(self.fc2(x))
        x = self.fc3(x)
        return x