import os
import json
import pandas as pd

"""
API Pool
"""
class API_Pool:
    def __init__(self, save_dir:str, snap_N:int=10):
        self.save_dir = save_dir
        self.init_pool(save_dir)
        self.snap_N = snap_N

    def init_pool(self, save_dir):
        self.snap_count = 0
        if os.path.exists(save_dir):
            self.pool = pd.read_json(save_dir, lines=True)
        else:
            self.pool = pd.DataFrame(columns=['Intent', 'Action', 'Tool'])

    def save_pool(self):
        self.pool.to_json(self.save_dir, orient='records', lines=True, force_ascii=False)

    def get_api_info(self):
        info = []
        for index, row in self.pool.iterrows():
            intent, action, tool = row.values.tolist()
            item_info = f"Intent: {intent}, Action: {action}, Tool: {tool}"
            info.append(item_info)
        info_str = '\n'.join(info)
        return info_str

    def get_api_info_from_keys(self, intent:str=None, action:str=None):
        filtered_pool = self.pool
        if intent is not None:
            filtered_pool = filtered_pool[filtered_pool['Intent'] == intent]
        if action is not None:
            filtered_pool = filtered_pool[filtered_pool['Action'] == action]
        info = []
        for index, row in filtered_pool.iterrows():
            intent, action, tool = row.values.tolist()
            item_info = f"Intent: {intent}, Action: {action}, Tool: {tool}"
            info.append(item_info)
        info_str = '\n'.join(info)
        return info_str

    def add_item(self, item:dict):
        new_row = {
            'Intent': item['Intent'],
            'Action': item['Action'],
            'Tool': item['Tool']
        }
        # self.api_pool = self.api_pool.append(new_row, ignore_index=True)
        self.pool = pd.concat([self.pool, pd.DataFrame([new_row])], ignore_index=True)
        self.snap_count += 1
        if self.snap_count >= self.snap_N:
            self.save_pool()
            self.snap_count = 0

    def drop_item(self, index:int):
        self.pool = self.pool.drop(index)

    def merge_item(self, index_1, index_2, new_item:dict):
        self.drop_item(index_1)
        self.drop_item(index_2)
        self.add_item(new_item)
    
    def get_pool_basic_info(self):
        item_info = f"Total items: {len(self.pool)}"
        intent_list = self.get_set_from_key('Intent')
        intent_info = f"Intent: {len(intent_list)}"
        action_list = self.get_set_from_key('Action')
        action_info = f"Action: {len(action_list)}"
        file_info = f"Saved to {self.save_dir}"
        info = [item_info, intent_info, action_info, file_info]
        info = "\n".join(info)
        return info

    def get_set_from_key(self, key)->list:
        key_set = self.pool[key].unique().tolist()
        return key_set