import gradio as gr
import pandas as pd
import numpy as np
import json
import os

index = 0
global_data_df = None

def get_values(index):
    global global_data_df
    info = global_data_df.loc[[index]]
    info_json = json.loads(info.to_json())
    score = info_json["score"][str(index)]
    system_prompt = info_json["system_prompt"][str(index)]
    user_prompt = info_json["user_prompt"][str(index)]
    action = pd.DataFrame(json.loads(info_json["action"][str(index)].replace("'", '"')), columns=["action"])
    ground_truth = pd.DataFrame(json.loads(info_json["ground_truth"][str(index)].replace("'", '"')))
    choice_space = pd.DataFrame(json.loads(info_json["choice_space"][str(index)].replace("\'s", "[s_token]").replace("\'", "\"").replace("[s_token]", "\'s")))
    return (
        score, action, ground_truth, system_prompt, user_prompt, choice_space, index
    )

def load_csv(file_path:str)->pd.DataFrame:
    global global_data_df
    global_data_df = pd.read_csv(file_path)
    return get_values(index)

def next_one():
    global index, global_data_df
    if index < len(global_data_df):
        index += 1
    return get_values(index)

def previous_one():
    global index, global_data_df
    if index > 1:
        index -= 1
    return get_values(index)

def go_to_index(idx):
    global index, global_data_df
    idx = int(idx)
    if 0 <= idx < len(global_data_df):
        index = idx
    return get_values(index)

# ================== Build APP ==================
def build_app():
    with gr.Blocks() as app:
        # ====== Layout ======
        gr.Markdown("# BargainBench Report Viewer")
            
        with gr.Row():
            with gr.Column(scale=1):
                gr.Markdown("## Load Data")
                local_dir = gr.Textbox(value="/mnt/workspace/workgroup/Benchmark/output/grader_report/test_report.txt", label="Local Directory", interactive=True, scale=3)
                btn_load = gr.Button("Load", scale=1)
                gr.Markdown("## ")
                gr.Markdown("## ")
                gr.Markdown("## ")
                gr.Markdown("## ")
                gr.Markdown("## Index")
                with gr.Row():
                    btn_prev = gr.Button("Prev", scale=1)
                    btn_next = gr.Button("Next", scale=1)
                index_textbox = gr.Textbox(label="index", interactive=True, scale=1)
                btn_index = gr.Button("Go", scale=1)
                
            with gr.Column(scale=4):
                gr.Markdown("## Prompts")
                sys_prompt_textbox = gr.Textbox(label="System Prompt", interactive=False)
                user_prompt_textbox = gr.Textbox(label="User Prompt", interactive=False)

        gr.Markdown("## Results")
        score_box = gr.Textbox(label="Score", interactive=False, scale=2)
        with gr.Row():
            with gr.Column(scale=2):
                gr.Markdown("## Actions")
                action_box = gr.DataFrame(headers=["Name"], interactive=False, show_row_numbers=True)
            with gr.Column(scale=4):
                gr.Markdown("## Ground Truth")
                ground_truth_box = gr.DataFrame(headers=["Name", "Descprition"], interactive=False, show_row_numbers=True)

        gr.Markdown("## Choice Space")
        choice_space_box = gr.DataFrame(headers=["Name", "Descprition"], interactive=False, show_row_numbers=True)
        # ==== Event ====
        btn_load.click(fn=load_csv, inputs=[local_dir], outputs=[score_box, action_box, ground_truth_box, sys_prompt_textbox, user_prompt_textbox, choice_space_box, index_textbox])
        btn_next.click(fn=next_one, inputs=[], outputs=[score_box, action_box, ground_truth_box, sys_prompt_textbox, user_prompt_textbox, choice_space_box, index_textbox])
        btn_prev.click(fn=previous_one, inputs=[], outputs=[score_box, action_box, ground_truth_box, sys_prompt_textbox, user_prompt_textbox, choice_space_box, index_textbox])
        btn_index.click(fn=go_to_index, inputs=[index_textbox], outputs=[score_box, action_box, ground_truth_box, sys_prompt_textbox, user_prompt_textbox, choice_space_box, index_textbox])
        # === Return ===
        return app

if __name__ == "__main__":
    app = build_app()
    server_port = 8866
    app.launch(server_port=server_port)