import json
from typing import Dict, Any

class TreeDB:
    def __init__(self):
        self.tree: Dict[str, Dict[str, Dict[str, Dict[str, Any]]]] = {}

    def add(self, intent: str, action: str, tool: str, description: str = None, parameters: dict = None):
        self.tree.setdefault(intent, {})
        self.tree[intent].setdefault(action, {})
        self.tree[intent][action][tool] = {
            "description": description or "",
            "parameters": parameters or {}
        }

    def to_json(self) -> str:
        return json.dumps(self.tree, indent=2, ensure_ascii=False)

    def display(self):
        for intent, actions in self.tree.items():
            print(f"📁 Intent: {intent}")
            for action, tools in actions.items():
                print(f"  └─ Action: {action}")
                for tool, meta in tools.items():
                    print(f"     └─ Tool: {tool}")
                    print(f"        └─ Description: {meta['description'][:60]}...")
                    print(f"        └─ Parameters: {list(meta['parameters'].keys())}")

# 示例数据
if __name__ == "__main__":
    db = TreeDB()
    db.add("Inquire_Product_Availability", "Check_Availability", "API_CheckAvailability")
    db.add("Inquire_Product_Availability", "Check_Availability", "API_CheckStock")
    db.add("Inquire_Product_Specification", "Request_Product_Details", "API_QuerySize")
    db.display()