import yaml
import json
import time
from openai import OpenAI

"""
Init LLM Client
"""
def init_client(config_file:str):
    config = yaml.safe_load(open(config_file, 'r'))
    client = LLMClient(
        api_key=config['API_KEY'],
        base_url=config['BASE_URL'],
        model_name=config['MODEL_NAME']
    )
    return client

"""
LLM Client
"""
class LLMClient:
    def __init__(self, api_key, base_url, model_name, qps=5, retry=3, sleep_time_ms=1000):
        self.base_url = base_url
        self.model_name = model_name
        self.client = OpenAI(
            api_key=api_key,
            base_url=base_url
        )
        self.qps = qps
        self.retry = retry
        self.sleep_time_ms = sleep_time_ms
    # chat completion 
    def _chat_completion(self, messages, **kwargs):
        count = 0
        while count < self.retry:
            try:
                response = self.client.chat.completions.create(
                    model=self.model_name,
                    messages=messages,
                    extra_body={"enable_thinking": False},
                    **kwargs
                )
                response = json.loads(response.model_dump_json())
                return response
            except Exception as e:
                print(e)
                print(f"Retrying {count} / {self.retry} times")
                count += 1
                time.sleep(self.sleep_time_ms / 1000)
                continue
        return None
    # chat once
    def chat(self, messages, **kwargs):
        return self._chat_completion(messages, **kwargs)

class AIBotLLM:
    def __init__(self, bot_id:str, online:bool=False, qps=5, retry=3, sleep_time_ms=1000):
        self.bot_id = bot_id
        self.qps = qps
        self.retry = retry
        self.sleep_time_ms = sleep_time_ms
        if online:
            self.url = "http://idleai.alibaba-inc.com/bot/execute"
        else:
            self.url = "http://pre-idleai.alibaba-inc.com/bot/execute"
    # chat completion 
    def _chat_completion(self, messages, **kwargs):
        count = 0
        while count < self.retry:
            try:
                # response = self.client.chat.completions.create(
                #     model=self.model_name,
                #     messages=messages,
                #     **kwargs
                # )
                # response = json.loads(response.model_dump_json())
                # return response
                pass
            except Exception as e:
                # print(e)
                # count += 1
                # time.sleep(self.sleep_time_ms / 1000)
                continue
        return None
    # chat once
    def chat(self, messages, **kwargs):
        return self._chat_completion(messages, **kwargs)
        
