# Action Space Analysis Script

## Overview
This Python script (`action_space_analyze.py`) analyzes aggregated JSON results from HID (Hierarchical Intent Decomposition) extractions. It generates histograms, pie charts, and a CSV for merge details, visualizing Intent and Action distributions.

## Usage
1. Prepare your aggregated JSON file (e.g., `agg_example.json`).
2. Run the script: `python action_space_analyze.py`
   - It reads from the hardcoded file ('agg_example.json').
   - Outputs: Console visualizations, PNG charts (e.g., `agg_example_Intent_distribute_bar.png`), and a CSV (e.g., `agg_example_merge_detail.csv`).

## Outputs
- **Console**: Colored bar charts and ASCII pie charts for Intent and Action distributions.
- **PNG Files**: Matplotlib-generated bar and pie charts saved in the same directory.
- **CSV File**: Details of merged labels for auditing in Excel or Pandas.

## Dependencies
- Python 3.x
- matplotlib (for charts)
- Install via `pip install matplotlib`

## Example
After running, check the generated files for visualizations and import the CSV for further analysis.

If you encounter errors (e.g., NameError), ensure variables like file paths are correctly defined. 