import json
from tree_db import TreeDB

# 初始化数据库
db = TreeDB()

# 从 action100.json 加载数据
with open("intent66-v2.json", "r", encoding="utf-8") as f:
    data = json.load(f)

for intent, actions in data.items():
    for action, tools in actions.items():
        for tool, info in tools.items():
            description = info.get("description", "")
            parameters = info.get("parameters", {})
            db.add(intent, action, tool, description, parameters)

# ✅ 可选：保存为 JSON 文件
with open("merged_tree_intent66-v2.json", "w", encoding="utf-8") as f:
    f.write(db.to_json())



# ✅ 可选：终端显示
db.display()

# Count and print IAT numbers
num_intents = len(db.tree)
num_actions = sum(len(actions) for actions in db.tree.values())
num_tools = sum(len(tools) for actions in db.tree.values() for tools in actions.values())
print(f"\nTotal IAT: {num_intents} Intents, {num_actions} Actions, {num_tools} Tools")