from flask import Flask, request, jsonify, render_template_string
from tree_db import TreeDB

app = Flask(__name__)
db = TreeDB()

@app.route("/")
def index():
    return render_template_string("""
    <h2>树状结构数据库</h2>
    <form action="/add" method="post">
        Intent: <input name="intent"><br>
        Action: <input name="action"><br>
        Tool: <input name="tool"><br>
        <input type="submit" value="添加">
    </form>
    <pre>{{ tree }}</pre>
    """, tree=db.to_json())

@app.route("/add", methods=["POST"])
def add():
    db.add(request.form["intent"], request.form["action"], request.form["tool"])
    return index()

@app.route("/remove", methods=["POST"])
def remove():
    db.remove_intent(request.form["intent"])
    return index()

if __name__ == "__main__":
    app.run(debug=True)