import os

Confidence_Level_Prompt = """
assign a confidence score from 1 to 5 that reflects how likely you believe your answer is correct:

1: Pure guess or very likely wrong
2: Low confidence, answer may be wrong
3: About 50/50 confidence
4: High confidence with small chance of error
5: Almost certain, very high confidence
"""

MultiTurn_Script_to_Task_Prompt = """
You are a master multi-turn script-to-task writer. 
Your ONLY inputs are:

1. {product_info} - a short text containing the item description, price, and category.
2. {ground_truth_conditions} - an ordered list of k atomic buyer intents (c1…ck) that the buyer must eventually confirm or inquire about.

Definitions:
- Each condition ci is a specific **intent** about the product (e.g., confirm size suitability, ask about defects, query shipping, negotiate price).
- Multi-turn conversation: Q1, A1, Q2, A2, …, Qk, Ak (Q means buyer question, A means seller answer)
- P = product_info (remains fixed across the conversation)

Your job:
Step 1 - Generate exactly k = {number_of_turns} natural-sounding buyer questions Q1…Qk in English, where:
    - Qi **only reveals one new intent** from the list, but can naturally reference any previously learned facts.
    - Keep each buyer utterance ≤ 35 words.
    - Add plausible personal context to make it realistic.

Step 2 - For each round i ≥ 1, generate seller reply Ai in English:
    - Natural fluency, grounded in {product_info} details;
    - Answer only the buyer's revealed intent so far;
    - No leaking of yet-unasked conditions;
    - May include clarifications, follow-up questions, polite closure.

Return:
{multi_turn_dialogue}: a JSON array of objects, each with:
    {
      "round": i,
      "buyer_question": <Qi string>,
      "prev_context": [<alternating Q/A strings from all previous rounds, if any, else empty array>],
      "prev_intent_choice": []  # Always leave this empty. Do not fill it in.
    }

Rules:
- Translate Chinese in {product_info} to natural English.
- Maintain realism — avoid robotic listing of facts. 
- Include light conversational elements where appropriate.
- Keep intents in the *exact* shuffled order in your output.

---

Sample Input:
product_info:
Sam's Club Elsa Princess Dress, size 140. Worn once for photos—like new. ¥58. Kids' Apparel > Dresses > Princess Dresses.
ground_truth_actions:
[API_CheckHeightFit, API_QueryShippingPolicy, API_CalculateOfferPrice]
ground_truth_action:
[
  {
    "Round": 1,
    "Tool": "API_CheckHeightFit",
    "Description": "Check if the product is suitable for the buyer's height or body measurements"
  },
  {
    "Round": 2,
    "Tool": "API_QueryShippingPolicy",
    "Description": "Query whether the item is eligible for free shipping"
  },
  {
    "Round": 3,
    "Tool": "API_CalculateOfferPrice",
    "Description": "Calculate a reasonable offer price based on item's marked price and negotiation stage"
  }
]

Sample Output:
[
  {
    "round": 1,
    "buyer_question": "My daughter is 135 cm. Do you think the size 140 dress will fit her well?",
    "prev_context": [],
    "prev_intent_choice": []
  },
  {
    "round": 2,
    "buyer_question": "Would you be able to offer free shipping for this dress?",
    "prev_context": [
        "Q1: My daughter is 135 cm. Do you think the size 140 dress will fit her well?",
        "A1: Yes, size 140 usually fits children around 135-145 cm. It should be comfortable with a little room to grow."
    ],
    "prev_intent_choice": []
  },
  {
    "round": 3,
    "buyer_question": "Could you do 50 yuan if we go ahead?",
    "prev_context": [
        "Q1: My daughter is 135 cm. Do you think the size 140 dress will fit her well?",
        "A1: Yes, size 140 usually fits children around 135-145 cm. It should be comfortable with a little room to grow.",
        "Q2: Would you be able to offer free shipping for this dress?",
        "A2: Currently, shipping is 8 yuan, but I can cover it if you take the item at this price."
    ],
    "prev_intent_choice": []
  }
]
"""

MultiTurn_Evaluation_Prompt = """
You are a dialogue evaluator for multi-turn buyer-seller conversations on a secondhand trading platform.

Inputs:
1. product_info - details about the item.
2. dialogue_history - the full conversation so far (from round 1 to the current round i), with each speaker labelled in order.
3. intent_choice_space - the complete list of possible atomic buyer intents.

Your task:
- Read product_info and dialogue_history carefully.
- From intent_choice_space, identify all buyer intents that have been **explicitly or implicitly expressed** up to this round.
- Preserve the exact order in which the buyer introduced them.
- Output only the identified intents in strict JSON array format (double quotes, valid JSON).

Rules:
- Only include an intent from intent_choice_space if it is clearly signaled by the buyer's words.
- If ambiguous, include it only if a reasonable human seller would interpret it as expressed intent.
- Do NOT assume any intent not directly supported by dialogue content.
- Return only the JSON array — no explanations, no commentary, no additional text.

---

Sample Input:
product_info:
Sam's Club Elsa Princess Dress, size 140. Worn once for photos—like new. ¥58. Category: Kids' Apparel > Dresses > Princess Dresses.

dialogue_history:
Buyer: My daughter is 135 cm. Do you think the size 140 dress will fit her well?
Seller: Yes, size 140 usually fits children around 135-145 cm. It should be comfortable with a little room to grow.  
Buyer: Would you be able to offer free shipping for this dress?  
Seller: That's possible depending on the final price we agree on.

intent_choice_space:
["API_CheckHeightFit", "API_QueryShippingPolicy", "API_CalculateOfferPrice", "Emotion_ExpressDistress", "Tool_Greet"]

Sample Output:
["API_CheckHeightFit", "API_QueryShippingPolicy"]
"""



Script_to_Task_Prompt = """

You are a master script-to-task writer.  
Your ONLY inputs are:

1. {product_info} - a short text containing the item description, price, and category.
2. {ground_truth_action} - an ordered list of API calls that the buyer must eventually issue.

Notes: Product info are match with format: item_desc, item_price, channel_cate_level1_name, channel_cate_level2_name, channel_cate_level3_name,channel_cate_level4_name

Your job is first generate  {buyer_question} in English that naturally triggers the {ground_truth_action}.  
Feel free to add a plausible personal context so the question looks realistic.

Rules  
- Keep the question under 40 words.  
- Mention only the **first** API in the Ground Truth list; do not reveal the rest.  
- Translate any Chinese terms in {product_info} into natural English.  
- Do not quote the API names literally; phrase the concern in everyday language.
---


Sample Input  
product_info:  
Sam's Club Elsa Princess Dress, size 140. Worn once for photos—like new. ¥58. Kids' Apparel > Dresses > Princess Dresses. 
[API_CheckHeightFit, API_QueryShippingPolicy, API_CalculateOfferPrice]

Above action refers to:
 "API_CheckHeightFit": {
          "description": "Check if the product (e.g., bicycle) is physically suitable for the buyer based on their height or body measurements",
          "parameters": {
            "fit_result": { "type": "string", "enum": ["suitable", "too_small", "too_large", "uncertain"] },
            "reason": { "type": "string" }
          }
        }
      }
    },

    "Inquire_Shipping_Logistics": {
      "Check_Shipping_Policy": {
        "API_QueryShippingPolicy": {
          "description": "Query whether the item is eligible for free shipping based on product details and seller settings",
          "parameters": {
            "free_shipping": { "type": "boolean", "description": "Indicates if the item is eligible for free shipping" },
            "shipping_fee": { "type": "number", "description": "The shipping cost if not free, in yuan" },
            "shipping_notes": { "type": "string", "description": "Additional notes about shipping" }
          }
        },

        "API_CalculateOfferPrice": {
          "description": "Calculate a reasonable offer price based on item's marked price, bottom price, and negotiation stage",
          "parameters": {
            "offered_price": { "type": "number" },
            "shipping_included": { "type": "boolean" }
          }
        },

Sample {buyer_question}:
“My daughter is 135 cm—will the size 140 be too big for her? Could you do 50 yuan with free shipping?”

---

Your output should strictly follow the format. Otherwise, a cute kitty will starve for a dineer.
Your Only Output are: 

{buyer_question}: a single-turn buyer question in English, in natural language.
{ground_truth_action}: exactly match with input
{candidate_system_prompt}: You are a seller proxy on a secondhand trading platform, assisting sellers in handling conversations with buyers. 
Your core task is to identify buyer intent based on information provided by the seller and messages from the buyer, in order to advance the transaction. 
Within a single round of dialogue, analyze the buyer's intent and 
Choose any 1 to n actions from {action_choice_space} (n = size of {action_choice_space}) that best satisfy the buyer's request, 
then list them in the exact order the buyer implied.

Ignore the parameters for now.

Example output (replace with your selections):
Question Answer: {ground_truth_action}
Product info: {product_info}
Buyer question: {buyer_question}
Return only the ordered list of actions in the required format.

"""

Candidate_user_prompt = """
Product info: {product_info}
Buyer question: {buyer_question}
"""

Maintainer_Analyze_and_Merge_Prompt = """
You are a data analyst.  
Input: a JSON Lines file where each line has the keys {"Intent": "...", "Action": "...", "Tool": {...}}.  
Task:  
Merge semantically similar Intents into a single category label.
“Similar” means they share the same functional purpose.
Example: any question about product appearance, packaging, color, logo, etc., becomes "Inquire_Product_Appearance".
If under same intent, Merge semantically similar Actions into a single category label.
Example: “confirm logo exists”, “check brand mark on back”, “verify emblem” all become "Confirm_Brand_Logo".
If under same intent and action, Merge functionally similar tools into a single category label. That means if two tools execute the same thing or are likely to have similar results after execution, they should be merged into a single category label.
For merged tools, create a representative Tool JSON by selecting or combining the most appropriate description and parameters from the group.

Output a JSON object with two parts separated by &&&###&&&.

The first part is the merge history as a JSON object with histograms and merge logs:
{
  "intent_histogram": { "<merged_intent_category>": <count>, ... },
  "action_histogram": { "<merged_intent_category>/<merged_action_category>": <count>, ... },
  "tool_histogram": { "<merged_intent_category>/<merged_action_category>/<merged_tool_category>": <count>, ... },
  "merge_log": {
    "intents": { "<merged_intent_category>": ["<original_intent1>", "<original_intent2>", ...], ... },
    "actions": { "<merged_intent_category>": { "<merged_action_category>": ["<original_action1>", "<original_action2>", ...], ... }, ... },
    "tools": { "<merged_intent_category>/<merged_action_category>": { "<merged_tool_category>": ["<original_tool_name1>", "<original_tool_name2>", ...], ... }, ... }
  }
}

The second part is the complete merged action space as a JSON object:
{
  "Inquire_Product_Availability": {
    "Check_Availability": {
      "API_CheckAvailability": {
        "description": "Check whether the item is still available for purchase",
        "parameters": {
          "available": { "type": "boolean" }
        }
      },


"""

EXTRACTOR_SYSTEM_PROMPT = """
You will use the Hierarchical Intent Decomposition (HID) framework to analyze the data. This framework is used to extract and structure intents from dialogue data, forming a tree-like hierarchical structure. HID decomposes intents into three orthogonal levels to ensure atomicity, orthogonality, and scalability:
!!! Note, you are an advanced text understanding master and intent recognition expert with rich knowledge. Please fully understand the text and provide intents, not limited to the examples I give.
- Intent (Root): The coarse-grained overall goal of the dialogue 
- Action (Level 1 Branches): Mutually exclusive mid-level stages or categories, with no overlap. These are orthogonal, and if needed, can be expanded through sub-branches.
- Tool (Leaves): Fine-grained atomic operations with a single intent and callable, with parameters (e.g., {'name': 'API_QueryPrice', 'description': 'Query item price', 'returns': {'price': {'type': 'number'}}} ). Tools have no child nodes to maintain atomicity.

When processing input data (e.g., raw dialogue JSON with context, history, and features), follow these steps:
1. Extract the root-level Intent based on the overall goal.
2. Decompose into orthogonal Actions, selecting from a predefined set or expanding if necessary (ensuring no overlap).
3. Generate atomic Tools for each Action in JSON object format, including 'name', 'description', and 'returns' (including type/enum where appropriate).
4. For Tool generation, abstract and extract elements from the original text as much as possible, without needing to be very specific.

Ensure the output is consistent, atomic (each Tool has a single purpose), orthogonal (no category overlap), and extensible (if data introduces new intents, suggest new Actions/Tools without violating rules). For the given input, generate the HID decomposition result.

I provide a dialogue segment, where "| buyer |" indicates the buyer's real person role, "| seller |" indicates the seller's real person role, "| bot |" indicates the bot role.
Please generate the HID decomposition result for the "| buyer |" i.e., the buyer's role utterances in the dialogue content.

Output format:
Please output in JSON format, including the keys, in English:
- Intent: intent, please judge based on your own knowledge, not limited to the examples I give
- Action: action, please judge based on your own knowledge, not limited to the examples I give
- Tool: JSON format, including attributes like name, description, returns, etc., name strictly requires English output, others no requirements
"""

EXTRACTOR_USER_PROMPT = """
Input dialogue:
{dialogue}
"""

def make_extractor_user_prompt(dialogue:str):
    return EXTRACTOR_USER_PROMPT.format(dialogue=dialogue)


VERIFIER_SYSTEM_PROMPT = """
You will be responsible for checking whether the newly added Intent-Action-Tool conflicts with the existing action space. Assume that the new Intent-Action-Tool itself is valid (atomicity, clarity, etc., all meet requirements), your only task is to check whether it conflicts with the Intent-Action-Tool in the existing space, including category overlap (non-orthogonal) or functional similarity (duplication).

Each Intent-Action-Tool is a triplet, with "Intent", "Action", "Tool" three key values respectively.

In the action space, all Intent-Action-Tools are organized into three levels: Intent --> Action --> Tool

First, find the corresponding Tools information based on Intent and Action information, and check if the target Tool conflicts with existing Tools.

Verification principles (focusing on conflict detection):
- Each Tool is represented in JSON format, including name, description, parameters, etc., need to compare each piece of information one by one
- Read and understand name, description information to judge whether there is duplication or conflict
- Check if the new Action overlaps with existing Actions (e.g., if existing has 'bargaining', new 'price negotiation' overlaps).
- Check if the new Tool's function is similar to existing Tools, you can assist judgment by checking description and parameters (e.g., if existing has 'API_QueryPrice', new 'API_GetItemCost' is functionally duplicate).
- Ensure orthogonality: new items should not cross or copy existing categories.
- If there is no conflict at all, accept; otherwise reject.

Verification steps:
1. Compare the new Intent-Action-Tool with the existing space.
2. Output only one of the following two (strictly follow the format, no additional explanation):
   - "1: No conflict, accept new API"
   - "2: Has conflict, reject"

Input example: Existing space: {'Intent': 'Facilitate transaction', 'Actions': [{'name': 'Information query', 'Tools': [{'name': 'API_QueryPrice'}]}]}; New item: {'Action': 'Bargaining', 'Tool': {'name': 'API_ProposeCounteroffer'}}.
Output requirements:
Please output in JSON format, including the following keys:
- status: 1 means no conflict, 2 means has conflict
"""

VERIFIER_USER_PROMPT = """
Current existing Intent-Action-Tool list (if no data, it means the current action space has not added actions yet, you can add with confidence):
{IAT_list}
Input Intent-Action-Tool:
{Intent_Action_Tool}
"""

Expert_Knowledge_PROMPT_COLD_START = """
You are an expert in the HID framework, which is used to extract and structure intents from dialogue data, forming a tree-like hierarchical structure of Intent-Action-Tool. 
Now, your task is to perform a cold start of the action space: based on the provided company {domain_knowledge_materials}
 (such as process documents, rule manuals, transaction guides, etc.), generate the initial HID structure. As a cold start guide, these materials will help you build an orthogonal, atomic, and extensible action space from scratch, rather than expanding from an existing space.

Review the HID definition:
- Intent (Root): Coarse-grained overall goal (e.g., 'Facilitate transaction').
- Action (Level 1 Branches): Mutually exclusive mid-level categories, with no overlap (e.g., 'Information query', 'Bargaining'). These should be based on core stages or processes in the business materials.
- Tool (Leaves): Fine-grained atomic operations, with a single intent and callable, including 'name', 'description', and 'returns' (e.g., {'name': 'API_QueryPrice', 'description': 'Query item price', 'returns': {'price': {'type': 'number'}}}).

Cold start steps:
1. Analyze the provided business materials, extract key processes, rules, and operations (e.g., if the materials describe the inquiry process for second-hand transactions, map it to Actions and Tools).
2. Generate root-level Intent (usually 1, based on the overall business goal).
3. Create initial Action branches: Summarize mutually exclusive categories from the materials, ensuring orthogonality (no overlap) and coverage (covering major business scenarios). If the materials introduce new concepts, expand but keep concise (4-6 core Actions).
4. Generate atomic Tools for each Action: Based on specific operations in the materials, ensure each Tool has a single intent, no child nodes, and includes parameters/return types.
5. Validate the overall structure: Ensure atomicity (Tools are indecomposable), orthogonality (no overlap between Actions), and extensibility (easy to add in the future).

Input: Company business materials text (e.g., “Company second-hand transaction process: 1. Buyer queries item information, including price and shipping. 2. Bargaining stage, seller can adjust price. 3. Confirm transaction, handle payment and logistics. 4. End feedback, including evaluation.”).

Output format: JSON object representing the initial HID tree, e.g.:
{
  "Intent": "Facilitate transaction",
  "Actions": [
    {
      "name": "Information query",
      "description": "Handle item-related queries",
      "Tools": [
        {"name": "API_QueryPrice", "description": "Query item price", "returns": {"price": {"type": "number"}}}
      ]
    }
  ]
}

Generate the initial structure based on the input materials, ensuring fidelity to the business logic without fabricating content.
"""

Expert_Knowledge_PROMPT_Guide = """
The following is an introduction to the business, serving as background guidance for the HID framework cold start. Please note that this introduction is only used to provide business context to help you understand typical scenarios, but it should not directly influence or guide the specific generation of Intent, Action, and Tool. The construction of the action space should be independently based on dialogue data analysis, not any details in this description.

{domain_knowledge_materials}

Use this introduction as background knowledge, but when generating the HID structure, you must conduct independent analysis strictly based on the input dialogue data, without referencing or being limited by the above content.
"""


def make_verifier_user_prompt(item:str, item_list:str):
    return VERIFIER_USER_PROMPT.format(Intent_Action_Tool=item, IAT_list=item_list) 