import numpy as np
import math

def add_noise(train_label, noise_level, seed=0):
    np.random.seed(seed)

    # get the energy of input data
    data_power = np.sum(np.square(train_label))

    # create Gaussian noise
    size = len(train_label)
    noise = np.random.randn(size, 1) * noise_level
    noise = noise.astype('float32')
    noise_power = np.sum(np.square(noise))

    # calculate SNR
    SNR = 10 * math.log10(data_power / noise_power)
    return train_label + noise, SNR
