<p align="center"><img src="assets/teaser.png" /></p>

# LEDetection: Label-Efficient Object Detection

## Why LEDetection?
LEDetection (French pronounciation as `leuh` detection), short for *label-efficient object detection*, is an open-source toolbox focused on semi-supervised and few-shot object detection, both of which are important and emerging topics in computer vision. LEDetection enables modern detection systems to do more with less hand-labeled data, thereby alleviating the dependency on large amounts of instance-level class annotations and bounding boxes.

### Highlights and Features

* LEDetection is based on [MMDetection](https://github.com/open-mmlab/mmdetection), and PyTorch, thus inherits all of its world-class features including its modular design and high efficiency;
* Use LEDetection to train contemporary, high-performance supervised MMDetection models out-of-the-box;
* Add unlabeled data to train LEDetection models for state-of-the-art semi-supervised and few-shot detection performances.

Our goal is to expand the utility of LEDetection for the CV/ML practitioner by incorporating the latest advances in self-supervised, semi-supervised, and few-shot learning to boost the accuracy performance of conventional supervised detectors in the limited labeled data setting.

### One Toolbox - Multiple Detection Paradigms
LEDetection is versatile to support multiple detection paradigms including supervised, semi-supervised, few-shot, and semi-supervised few-shot.

**Supervised Detection**

Use LEDetection to train popular supervised detection frameworks such as Faster R-CNN, Mask R-CNN, etc. See example configs at `configs/supervised/`.

**Semi-Supervised Detection**

Add unlabeled data to your LEDetection pipeline to enable robust semi-supervised detection using the implemented [Soft Teacher](https://arxiv.org/abs/2106.09018) and SoftER Teacher models. See example configs at `configs/semi_supervised/`.

**Few-Shot Detection**

LEDetection models can be re-purposed into label-efficient few-shot detectors by way of transfer learning. See example configs at `configs/few_shot/`.

**Semi-Supervised Few-Shot Detection**

Why not combine both semi-supervised and few-shot training protocols, on datasets with limited labels, to enable semi-supervised few-shot detection, as described in our paper? See example configs at `configs/semi_few_shot/`.

## Get Started
Getting started is quick and easy:

1. Please refer to the installation guide at `docs/installation.md`;
2. Have fun with the quickstart guide at `docs/quickstart.md`.

## License
We release LEDetection under the permissive Apache 2.0 license. Any contributions made will also be subject to the same licensing.

## Acknowledgments
We are grateful for the open-source contributions from 

* [PyTorch](https://pytorch.org/),
* [OpenMMLab MMDetection](https://github.com/open-mmlab/mmdetection),
* [Microsoft SoftTeacher](https://github.com/microsoft/SoftTeacher),

and many other projects by the broader CV/ML communities, without which this project would not have been possible.