color_map = {
    "untrained": {
        "downsampling": "#A9A9A9",
        "l1": "#A9A9A9"
    },
    "pretrained": {
        "downsampling": "#DA70D6",
        "l1": "#DA70D6"
    },
    "baseline": {
        "downsampling": "#000000",
        "l1": "#000000"
    },
    "topo_1": {
        "downsampling": "#CB181D",
        "l1": "#CB181D"
    },
    "topo_5": {
        "downsampling": "#FB6A4A", 
        "l1": "#FB6A4A" 
    },
    "topo_10": {
        "downsampling": "#FF9966", 
        "l1": "#FF9966" 
    },
    "topo_50": {
        "downsampling": "#FEE0D2",  
        "l1": "#FEE0D2"  
    }
}

def parse_eval_results(
    results: dict,
    max_num_compression_factors = 12,
    color_map: dict = color_map
):
    parsed_results = []

    for key in results:
        if key == "pretrained":
            continue
        ## key is usually: baseline, topo_5, topo_10, ...
        for compression_type in ["downsampling", "l1"]:
            single_result_data = [
                x for x in results[key] if (
                    x["compression_type"] == compression_type
                    or x["compression_type"] == None
                )
            ]
            compression_factors = [
                x["factor"] for x in single_result_data
            ]
            losses = [
                x["result"] for x in single_result_data
            ]
            compression_factors = compression_factors[:max_num_compression_factors]
            losses = losses[:max_num_compression_factors]

            model_type = single_result_data[0]["type"]

            if model_type.startswith("topo"):
                topo_scale = int(model_type.split("_")[-1])
                label = f"Topo ($\\tau = {topo_scale}$) {compression_type}"
            else:
                label = f"{model_type} {compression_type}"

            parsed_results.append(
                {
                    "label": label,
                    "x": compression_factors,
                    "y": losses,
                    "color": color_map[key][compression_type]
                }
            )

    return parsed_results