from nesim.utils.tmux import launch_job_in_tmux

def divide_list(lst, n):
    """
    Divide a list into n roughly equal parts.

    Parameters:
    lst (list): The list to be divided.
    n (int): The number of parts to divide the list into.

    Returns:
    list of lists: A list containing n sublists.
    """
    if n <= 0:
        raise ValueError("The number of parts must be a positive integer.")
    
    # Calculate the size of each part
    avg = len(lst) // n
    remainder = len(lst) % n

    result = []
    start = 0

    for i in range(n):
        end = start + avg + (1 if i < remainder else 0)
        result.append(lst[start:end])
        start = end

    return result

gpus = [0, 1]

commands = [
    "python3 eval.py --checkpoint-name topo_50",
    "python3 eval.py --checkpoint-name topo_10",
    "python3 eval.py --checkpoint-name topo_5",
    "python3 eval.py --checkpoint-name topo_1",
    "python3 eval.py --checkpoint-name baseline",
    "python3 eval.py --checkpoint-name untrained",
]

commands = [
    f"conda activate nesim && CUDA_VISIBLE_DEVICES={gpu} {c}"
    for (gpu, c) in zip(gpus, commands)
]

count = 0
for c in commands:
    launch_job_in_tmux(
        command = c,
        session_name=f"eval-{count}"
    )
    count +=1 