from pydantic import BaseModel, Field


class ExponentialDecayScale(BaseModel, extra="allow"):
    """
    A class representing an exponential decay scaling function.

    Parameters:
        - `start_value` (float): The initial value of the scaling function.
        - `end_value` (float): The final value of the scaling function.
        - `damping_factor` (float): The damping factor determining the rate of decay.
        - `n_samples` (int): The number of samples to generate the scaling values.
    """

    start_value: float
    end_value: float
    damping_factor: float
    n_samples: int
    ## constant for ease of reading config json files
    scale_type: str = Field("damped_exponential_scale", Literal=True, type=str)

    def get_name(self):
        ## this is for configs
        return f"start_value_{self.start_value}_end_value_{self.end_value}_damping_factor_{self.damping_factor}_n_samples_{self.n_samples}"
