def divide_list(lst, n):
    """
    Divide a list into n roughly equal parts.

    Parameters:
    lst (list): The list to be divided.
    n (int): The number of parts to divide the list into.

    Returns:
    list of lists: A list containing n sublists.
    """
    if n <= 0:
        raise ValueError("The number of parts must be a positive integer.")
    
    # Calculate the size of each part
    avg = len(lst) // n
    remainder = len(lst) % n

    result = []
    start = 0

    for i in range(n):
        end = start + avg + (1 if i < remainder else 0)
        result.append(lst[start:end])
        start = end

    return result