def convert_number_to_human_readable(number):
    millions = number / 1e6
    billions = number / 1e9

    if billions >= 1:
        param_str = f'{billions:.2f} billion'
    elif millions >= 1:
        param_str = f'{millions:.2f} million'
    else:
        param_str = f'{number}'
    return param_str

def count_model_parameters(model):
    total_params = sum(p.numel() for p in model.parameters())
    param_str = convert_number_to_human_readable(total_params)

    return total_params, param_str