# Inspired by XXXX
#!/bin/sh
OUTPUT_FOLDER=""

# Parse command line arguments
while [ $# -gt 0 ]; do
    case "$1" in
        --output-folder)
            OUTPUT_FOLDER="$2"
            shift 2
            ;;
        *)
            echo "Unknown option: $1"
            exit 1
            ;;
    esac
done

# prepare training files
cd "${OUTPUT_FOLDER}/train" && find . -name "*.tar" | while read NAME ; do mkdir -p "${NAME%.tar}"; tar -xvf "${NAME}" -C "${NAME%.tar}"; rm -f "${NAME}"; done

# prepare validation files
cd "${OUTPUT_FOLDER}/val" && wget -qO- XXXX | sh

echo "Train samples (expected: 1281167):"
find "${OUTPUT_FOLDER}/train" -type f -name "*.JPEG" | wc -l

echo "Val samples (expected: 50000):"
find "${OUTPUT_FOLDER}/val" -type f -name "*.JPEG" | wc -l