# Experiments

## resnet18 + ImageNet

We followed the [pytorch recipe](XXXX) to train a resnet18 on the imagenet dataset with nesim loss.

### Training on nesim loss decreases adversarial robustness

Training with nesim loss decreases the adversarial robustness of a model.

Possible explanation is the presence of co-dimensions. [This paper](XXXX) mentions that the presence of co-dimensions facilitates adversarial attacks.

**Potential experiments**

1. Downsample nesim model layer weights and calculate adv. robustness. Maybe we'll see that it's more robust when sparse than that of baseline?
2. Forward pass the entire validation set through a topo model and plot the mean magnitude of the layer outputs. Maybe we'll see a correlation between the category selectivity maps and these magnitudes?

### Category Selectivity Maps

**The top-activating category labels for each output neuron is well organized**

We compute this by feeding a manually curated dataset through the model and computing, for each output neuron, the category of the samples which give the highest norm outputs.

XXXX

**Potential experiments**

1. Use XXXX-3's d' metric
2. Plot response similarity v/s cortical distance

### Models trained with nesim loss have embeddings with a much lower effective dimensionality

We compute the Effective Dimensionality (ED) of the intermediate encodings of 3 resnet18 models:

1. Baseline (from `torchvision.models`)
2. Trained with Nesim loss (ours)
3. Eshed's model

ED is computed on the outputs of the model's maxpool layers for 10,000 items in the imagenet validation set (this is how Eshed did it).

XXXX

The ED of models trained on nesim loss are much lower than that of vanilla models. But it's still significantly higher than that of Eshed's paper.

## GPT Neo 125M + wikitext

### Category Selectivity Maps

**The top-activating category labels for each output neuron is well organized**

We compute this by feeding a manually curated dataset through the model and computing, for each output neuron, the category of the samples which give the highest norm outputs.

XXXX

The manually curated dataset in this case contained various categories expected to be present in the wikitext dataset like: politics, science, history, sports, etc.

**The d' values of each category is also well organized. I'll add that plot here soon (TODO)**

**Potential experiments**

1. Plot top-activatng categories and d' values for all topo layers and not just the last one.
1. Plot response similarity v/s cortical distance

### Models trained with nesim loss have embeddings with a much lower effective dimensionality

We forward pass the test set through the model and observe that ED of the topo layers is much lower than that of baseline (trained without nesim loss). (**Figure 5**)

XXXX

## resnet18 + murty185

**Models trained with nesim loss out-perform Eshed's models by a small margin**

We took the resnet18 train with nesim loss on imagenet and Eshed's model and evaluated their performance in the murty185 dataset by training on intermediate outputs from various layers.

XXXX

## Sparsity on MNIST

We trained a simple MLP on MNIST with and without the nesim loss.

- (Blue v/s Orange line) Models trained with nesim loss perform *worse* than baseline with L1 sparsity
- (Green v/s Red line) Models trained with nesim loss perform *better* than baseline when we simply downsample the layer's weights (and hence it's outputs) during the forward pass
- (Green v/s Orange line at x = `24.08x`) Models trained with nesim loss, when downsampled to the factor corresponding to it's original laplacian pyramid loss, out-performs baseline+L1 sparsity

XXXX

# Ideas

1. Can topography be used as a tool to induce grokking? Read the following:
   
    a. XXXX
   
    b. XXXX
