from nesim.utils.json_stuff import load_json_as_dict

def find_item_by_name(data, target_name):
    # Check if the current dictionary has the target name
    if data.get("name") == target_name:
        return data

    # If there are children, iterate through them recursively
    children = data.get("children", [])
    for child in children:
        result = find_item_by_name(child, target_name)
        if result:
            return result

    # Return None if no match is found
    return None

def get_lowest_level_names(dog_tree):
    # Initialize an empty list to store the lowest level names
    lowest_level_names = []
    
    # Define a helper function to recursively traverse the tree
    def traverse_tree(node):
        # Check if the current node has children
        if 'children' in node and node['children']:
            # If yes, recursively traverse the children
            for child in node['children']:
                traverse_tree(child)
        else:
            # If no children, it's a leaf node, so add its name to the list
            lowest_level_names.append(node['name'])
    
    # Start the traversal from the root node
    traverse_tree(dog_tree)
    
    return lowest_level_names

class WordNetHierarchy:
    def __init__(self, filename: str):
        self.data = load_json_as_dict(filename=filename)

    def get_class_names_from_parent_name(self, parent_name):
        result = get_lowest_level_names(find_item_by_name(data=self.data, target_name=parent_name))
        assert result is not None, f"Invalid parent_name: {parent_name}"
        return result